/*
 * Decompiled with CFR 0.152.
 */
package jcuda.nvptxcompiler;

import jcuda.CudaException;
import jcuda.JCudaVersion;
import jcuda.LibUtils;
import jcuda.LibUtilsCuda;
import jcuda.LogLevel;
import jcuda.nvptxcompiler.nvPTXCompileResult;
import jcuda.nvptxcompiler.nvPTXCompilerHandle;

public class JNvPTXCompiler {
    private static boolean exceptionsEnabled = false;

    private JNvPTXCompiler() {
    }

    public static void setLogLevel(LogLevel logLevel) {
        JNvPTXCompiler.setLogLevel(logLevel.ordinal());
    }

    private static native void setLogLevel(int var0);

    public static void setExceptionsEnabled(boolean enabled) {
        exceptionsEnabled = enabled;
    }

    private static int checkResult(int result) {
        if (exceptionsEnabled && result != 0) {
            throw new CudaException(nvPTXCompileResult.stringFor(result));
        }
        return result;
    }

    public static int nvPTXCompilerGetVersion(int[] major, int[] minor) {
        return JNvPTXCompiler.checkResult(JNvPTXCompiler.nvPTXCompilerGetVersionNative(major, minor));
    }

    private static native int nvPTXCompilerGetVersionNative(int[] var0, int[] var1);

    public static int nvPTXCompilerCreate(nvPTXCompilerHandle compiler, long ptxCodeLen, byte[] ptxCode) {
        return JNvPTXCompiler.checkResult(JNvPTXCompiler.nvPTXCompilerCreateNative(compiler, ptxCodeLen, ptxCode));
    }

    private static native int nvPTXCompilerCreateNative(nvPTXCompilerHandle var0, long var1, byte[] var3);

    public static int nvPTXCompilerDestroy(nvPTXCompilerHandle compiler) {
        return JNvPTXCompiler.checkResult(JNvPTXCompiler.nvPTXCompilerDestroyNative(compiler));
    }

    private static native int nvPTXCompilerDestroyNative(nvPTXCompilerHandle var0);

    public static int nvPTXCompilerCompile(nvPTXCompilerHandle compiler, int numCompileOptions, String[] compileOptions) {
        return JNvPTXCompiler.checkResult(JNvPTXCompiler.nvPTXCompilerCompileNative(compiler, numCompileOptions, compileOptions));
    }

    private static native int nvPTXCompilerCompileNative(nvPTXCompilerHandle var0, int var1, String[] var2);

    public static int nvPTXCompilerGetCompiledProgramSize(nvPTXCompilerHandle compiler, long[] binaryImageSize) {
        return JNvPTXCompiler.checkResult(JNvPTXCompiler.nvPTXCompilerGetCompiledProgramSizeNative(compiler, binaryImageSize));
    }

    private static native int nvPTXCompilerGetCompiledProgramSizeNative(nvPTXCompilerHandle var0, long[] var1);

    public static int nvPTXCompilerGetCompiledProgram(nvPTXCompilerHandle compiler, byte[] binaryImage) {
        return JNvPTXCompiler.checkResult(JNvPTXCompiler.nvPTXCompilerGetCompiledProgramNative(compiler, binaryImage));
    }

    private static native int nvPTXCompilerGetCompiledProgramNative(nvPTXCompilerHandle var0, byte[] var1);

    public static int nvPTXCompilerGetErrorLogSize(nvPTXCompilerHandle compiler, long[] errorLogSize) {
        return JNvPTXCompiler.checkResult(JNvPTXCompiler.nvPTXCompilerGetErrorLogSizeNative(compiler, errorLogSize));
    }

    private static native int nvPTXCompilerGetErrorLogSizeNative(nvPTXCompilerHandle var0, long[] var1);

    public static int nvPTXCompilerGetErrorLog(nvPTXCompilerHandle compiler, byte[] errorLog) {
        return JNvPTXCompiler.checkResult(JNvPTXCompiler.nvPTXCompilerGetErrorLogNative(compiler, errorLog));
    }

    private static native int nvPTXCompilerGetErrorLogNative(nvPTXCompilerHandle var0, byte[] var1);

    public static int nvPTXCompilerGetInfoLogSize(nvPTXCompilerHandle compiler, long[] infoLogSize) {
        return JNvPTXCompiler.checkResult(JNvPTXCompiler.nvPTXCompilerGetInfoLogSizeNative(compiler, infoLogSize));
    }

    private static native int nvPTXCompilerGetInfoLogSizeNative(nvPTXCompilerHandle var0, long[] var1);

    public static int nvPTXCompilerGetInfoLog(nvPTXCompilerHandle compiler, byte[] infoLog) {
        return JNvPTXCompiler.checkResult(JNvPTXCompiler.nvPTXCompilerGetInfoLogNative(compiler, infoLog));
    }

    private static native int nvPTXCompilerGetInfoLogNative(nvPTXCompilerHandle var0, byte[] var1);

    static {
        String libraryBaseName = "JNvPTXCompiler-" + JCudaVersion.get();
        String libraryName = LibUtils.createPlatformLibraryName(libraryBaseName);
        LibUtilsCuda.loadLibrary(libraryName, new String[0]);
    }
}

