/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.easyai.extensions.cuda;

import org.dromara.easyai.matrixTools.Matrix;

public class MatrixUtil {
    public static float[] toRowMajorArray(Matrix matrix) throws Exception {
        float[] res = new float[matrix.getX() * matrix.getY()];
        for (int i = 0; i < matrix.getX(); ++i) {
            for (int j = 0; j < matrix.getY(); ++j) {
                res[i * matrix.getY() + j] = matrix.getNumber(i, j);
            }
        }
        return res;
    }

    public static float[] toColumnMajorArray(Matrix matrix) throws Exception {
        float[] res = new float[matrix.getX() * matrix.getY()];
        for (int i = 0; i < matrix.getX(); ++i) {
            for (int j = 0; j < matrix.getY(); ++j) {
                res[j * matrix.getX() + i] = matrix.getNumber(i, j);
            }
        }
        return res;
    }

    public static double[] makeFp64UnitColumnMajorArray(int n) {
        double[] res = new double[n * n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                res[j * n + i] = i == j ? 1.0 : 0.0;
            }
        }
        return res;
    }

    public static float[] makeFp32UnitColumnMajorArray(int n) {
        float[] res = new float[n * n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                res[j * n + i] = i == j ? 1.0f : 0.0f;
            }
        }
        return res;
    }

    public static double[] makeFp64Array(int rows, int cols, double value) {
        double[] res = new double[rows * cols];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                res[j * rows + i] = value;
            }
        }
        return res;
    }

    public static float[] makeFp32Array(int rows, int cols, float value) {
        float[] res = new float[rows * cols];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                res[j * rows + i] = value;
            }
        }
        return res;
    }

    public static Matrix columnMajorArrayToMatrix(float[] array, int rows, int cols) throws Exception {
        Matrix matrix = new Matrix(rows, cols);
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                matrix.setNub(i, j, array[j * rows + i]);
            }
        }
        return matrix;
    }

    public static Matrix rowMajorArrayToMatrix(float[] array, int rows, int cols) throws Exception {
        Matrix matrix = new Matrix(rows, cols);
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                matrix.setNub(i, j, array[i * cols + j]);
            }
        }
        return matrix;
    }

    public static void setRowMajorArray(Matrix matrix, float[] array) throws Exception {
        for (int i = 0; i < matrix.getX(); ++i) {
            for (int j = 0; j < matrix.getY(); ++j) {
                matrix.setNub(i, j, array[i * matrix.getY() + j]);
            }
        }
    }

    public static void setColumnMajorArray(Matrix matrix, float[] array) throws Exception {
        for (int i = 0; i < matrix.getX(); ++i) {
            for (int j = 0; j < matrix.getY(); ++j) {
                matrix.setNub(i, j, array[j * matrix.getX() + i]);
            }
        }
    }
}

