/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.common.serializer;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.dromara.hmily.annotation.HmilySPI;
import org.dromara.hmily.common.exception.HmilyException;
import org.dromara.hmily.common.serializer.ObjectSerializer;

@HmilySPI(value="kryo")
public class KryoSerializer
implements ObjectSerializer {
    @Override
    public byte[] serialize(Object obj) throws HmilyException {
        byte[] bytes;
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
             Output output = new Output((OutputStream)outputStream);){
            Kryo kryo = new Kryo();
            kryo.writeObject(output, obj);
            bytes = output.toBytes();
            output.flush();
        }
        catch (IOException ex) {
            throw new HmilyException("kryo serialize error" + ex.getMessage());
        }
        return bytes;
    }

    @Override
    public <T> T deSerialize(byte[] param, Class<T> clazz) throws HmilyException {
        Object object;
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(param);){
            Kryo kryo = new Kryo();
            Input input = new Input((InputStream)inputStream);
            object = kryo.readObject(input, clazz);
            input.close();
        }
        catch (IOException e) {
            throw new HmilyException("kryo deSerialize error" + e.getMessage());
        }
        return (T)object;
    }
}

