/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.common.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class DefaultValueUtils {
    private static final int ZERO = 0;

    public static Object getDefaultValue(Class clazz) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        if (Boolean.TYPE.equals(clazz) || Boolean.class.equals((Object)clazz)) {
            return false;
        }
        if (Byte.TYPE.equals(clazz) || Byte.class.equals((Object)clazz)) {
            return 0;
        }
        if (Short.TYPE.equals(clazz) || Short.class.equals((Object)clazz)) {
            return 0;
        }
        if (Integer.TYPE.equals(clazz) || Integer.class.equals((Object)clazz)) {
            return 0;
        }
        if (Long.TYPE.equals(clazz) || Long.class.equals((Object)clazz)) {
            return 0L;
        }
        if (Float.TYPE.equals(clazz) || Float.class.equals((Object)clazz)) {
            return Float.valueOf(0.0f);
        }
        if (Double.TYPE.equals(clazz) || Double.class.equals((Object)clazz)) {
            return 0.0;
        }
        if (String.class.equals((Object)clazz)) {
            return "";
        }
        if (Void.TYPE.equals(clazz)) {
            return "";
        }
        Constructor<?>[] constructors = clazz.getDeclaredConstructors();
        Constructor<?> constructor = constructors[constructors.length - 1];
        constructor.setAccessible(true);
        Class<?>[] parameClasses = constructor.getParameterTypes();
        Object[] args = new Object[parameClasses.length];
        for (int i = 0; i < parameClasses.length; ++i) {
            Class<?> clazzes = parameClasses[i];
            args[i] = clazzes.isPrimitive() ? Integer.valueOf(0) : null;
        }
        return constructor.newInstance(args);
    }
}

