/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.common.utils.extension;

import java.util.Objects;
import java.util.ServiceLoader;
import java.util.stream.StreamSupport;
import org.dromara.hmily.annotation.HmilySPI;
import org.dromara.hmily.common.exception.HmilyException;
import org.dromara.hmily.common.utils.extension.ServiceBootstrap;

public final class ExtensionLoader<T> {
    private Class<T> type;

    private ExtensionLoader(Class<T> type) {
        this.type = type;
    }

    private static <T> boolean withExtensionAnnotation(Class<T> type) {
        return type.isAnnotationPresent(HmilySPI.class);
    }

    public static <T> ExtensionLoader<T> getExtensionLoader(Class<T> type) {
        if (type == null) {
            throw new HmilyException("type == null");
        }
        if (!type.isInterface()) {
            throw new HmilyException("Extension type(" + type + ") not interface!");
        }
        if (!ExtensionLoader.withExtensionAnnotation(type)) {
            throw new HmilyException("type" + type.getName() + "not exist");
        }
        return new ExtensionLoader<T>(type);
    }

    public T getActivateExtension(String value) {
        ServiceLoader<T> loader = ServiceBootstrap.loadAll(this.type);
        return (T)StreamSupport.stream(loader.spliterator(), false).filter(e -> Objects.equals(e.getClass().getAnnotation(HmilySPI.class).value(), value)).findFirst().orElseThrow(() -> new HmilyException("Please check your configuration"));
    }
}

