/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.common.utils.httpclient;

import java.io.Serializable;

public class AjaxResponse
implements Serializable {
    private static final long serialVersionUID = -2792556188993845048L;
    private int code;
    private String message;
    private Object data;

    public AjaxResponse(int code, String message, Object data) {
        this.code = code;
        this.message = message;
        this.data = data;
    }

    public static AjaxResponse success() {
        return AjaxResponse.success("");
    }

    public static AjaxResponse success(String msg) {
        return AjaxResponse.success(msg, null);
    }

    public static AjaxResponse success(Object data) {
        return AjaxResponse.success(null, data);
    }

    public static AjaxResponse success(String msg, Object data) {
        return AjaxResponse.get(200, msg, data);
    }

    public static AjaxResponse error(String msg) {
        return AjaxResponse.error(-2, msg);
    }

    public static AjaxResponse error(int code, String msg) {
        return AjaxResponse.get(code, msg, null);
    }

    public static AjaxResponse get(int code, String msg, Object data) {
        return new AjaxResponse(code, msg, data);
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public String toString() {
        return "AjaxResponse [code=" + this.code + ", message=" + this.message + ", data=" + this.data + "]";
    }
}

