/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.config.zookeeper;

import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.ACLProvider;
import org.apache.curator.framework.api.transaction.CuratorOp;
import org.apache.curator.framework.api.transaction.TransactionOp;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.CuratorCache;
import org.apache.curator.framework.recipes.cache.NodeCache;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.utils.CloseableUtils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;
import org.dromara.hmily.common.utils.StringUtils;
import org.dromara.hmily.config.api.Config;
import org.dromara.hmily.config.loader.ConfigLoader;
import org.dromara.hmily.config.zookeeper.ZkPassiveConfig;
import org.dromara.hmily.config.zookeeper.ZookeeperConfig;
import org.dromara.hmily.config.zookeeper.handler.CuratorZookeeperExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CuratorZookeeperClient
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(CuratorZookeeperClient.class);
    private static final Map<String, CuratorCache> CACHES = new HashMap<String, CuratorCache>();
    private static volatile CuratorZookeeperClient instance;
    private CuratorFramework client;

    private CuratorZookeeperClient() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CuratorZookeeperClient getInstance(ZookeeperConfig zookeeperConfig) {
        if (instance != null) return instance;
        Class<CuratorZookeeperClient> clazz = CuratorZookeeperClient.class;
        synchronized (CuratorZookeeperClient.class) {
            if (instance != null) return instance;
            instance = new CuratorZookeeperClient();
            instance.initCuratorClient(zookeeperConfig);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    private void initCuratorClient(ZookeeperConfig zookeeperConfig) {
        int retryIntervalMilliseconds = zookeeperConfig.getRetryIntervalMilliseconds();
        int maxRetries = zookeeperConfig.getMaxRetries();
        int timeToLiveSeconds = zookeeperConfig.getTimeToLiveSeconds();
        int operationTimeoutMilliseconds = zookeeperConfig.getOperationTimeoutMilliseconds();
        String digest = zookeeperConfig.getDigest();
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder().connectString(zookeeperConfig.getServerList()).retryPolicy((RetryPolicy)new ExponentialBackoffRetry(retryIntervalMilliseconds, maxRetries, retryIntervalMilliseconds * maxRetries));
        if (0 != timeToLiveSeconds) {
            builder.sessionTimeoutMs(timeToLiveSeconds * 1000);
        }
        if (0 != operationTimeoutMilliseconds) {
            builder.connectionTimeoutMs(operationTimeoutMilliseconds);
        }
        if (!Strings.isNullOrEmpty((String)digest)) {
            builder.authorization("digest", digest.getBytes(Charsets.UTF_8)).aclProvider(new ACLProvider(){

                public List<ACL> getDefaultAcl() {
                    return ZooDefs.Ids.CREATOR_ALL_ACL;
                }

                public List<ACL> getAclForPath(String path) {
                    return ZooDefs.Ids.CREATOR_ALL_ACL;
                }
            });
        }
        this.client = builder.build();
        this.client.start();
        try {
            if (!this.client.blockUntilConnected(retryIntervalMilliseconds * maxRetries, TimeUnit.MILLISECONDS)) {
                this.client.close();
                throw new KeeperException.OperationTimeoutException();
            }
        }
        catch (InterruptedException | KeeperException.OperationTimeoutException ex) {
            CuratorZookeeperExceptionHandler.handleException((Exception)ex);
        }
    }

    public InputStream pull(String path) {
        String content = this.get(path);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("zookeeper content {}", (Object)content);
        }
        if (StringUtils.isBlank((CharSequence)content)) {
            return null;
        }
        return new ByteArrayInputStream(content.getBytes());
    }

    public void addListener(Supplier<ConfigLoader.Context> context, ConfigLoader.PassiveHandler<ZkPassiveConfig> passiveHandler, ZookeeperConfig config) throws Exception {
        if (!config.isPassive()) {
            return;
        }
        if (this.client == null) {
            LOGGER.warn("zookeeper client is null...");
        }
        NodeCache cache = new NodeCache(this.client, config.getPath());
        cache.getListenable().addListener(() -> {
            byte[] data = cache.getCurrentData().getData();
            String string = new String(data, StandardCharsets.UTF_8);
            ZkPassiveConfig zkPassiveConfig = new ZkPassiveConfig();
            zkPassiveConfig.setPath(config.getPath());
            zkPassiveConfig.setFileExtension(config.getFileExtension());
            zkPassiveConfig.setValue(string);
            passiveHandler.passive(context, (Config)zkPassiveConfig);
        });
        cache.start();
        LOGGER.info("passive zookeeper remote started....");
    }

    public String get(String path) {
        CuratorCache cache = this.findTreeCache(path);
        if (null == cache) {
            return this.getDirectly(path);
        }
        Optional resultInCache = cache.get(path);
        if (resultInCache.isPresent()) {
            return null == ((ChildData)resultInCache.get()).getData() ? null : new String(((ChildData)resultInCache.get()).getData(), Charsets.UTF_8);
        }
        return this.getDirectly(path);
    }

    public void persist(String key, String value) {
        try {
            if (!this.isExisted(key)) {
                ((ACLBackgroundPathAndBytesable)this.client.create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT)).forPath(key, value.getBytes(Charsets.UTF_8));
            } else {
                this.update(key, value);
            }
        }
        catch (Exception ex) {
            CuratorZookeeperExceptionHandler.handleException(ex);
        }
    }

    private void update(String key, String value) {
        try {
            TransactionOp transactionOp = this.client.transactionOp();
            this.client.transaction().forOperations(new CuratorOp[]{(CuratorOp)transactionOp.check().forPath(key), (CuratorOp)transactionOp.setData().forPath(key, value.getBytes(StandardCharsets.UTF_8))});
        }
        catch (Exception ex) {
            CuratorZookeeperExceptionHandler.handleException(ex);
        }
    }

    @Override
    public void close() {
        CACHES.values().forEach(CuratorCache::close);
        this.waitForCacheClose();
        CloseableUtils.closeQuietly((Closeable)this.client);
    }

    private CuratorCache findTreeCache(String key) {
        return CACHES.entrySet().stream().filter(entry -> key.startsWith((String)entry.getKey())).findFirst().map(Map.Entry::getValue).orElse(null);
    }

    private boolean isExisted(String key) {
        try {
            return null != this.client.checkExists().forPath(key);
        }
        catch (Exception ex) {
            CuratorZookeeperExceptionHandler.handleException(ex);
            return false;
        }
    }

    private String getDirectly(String key) {
        try {
            return new String((byte[])this.client.getData().forPath(key), Charsets.UTF_8);
        }
        catch (Exception ex) {
            CuratorZookeeperExceptionHandler.handleException(ex);
            return null;
        }
    }

    private void waitForCacheClose() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }
}

