/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.config.zookeeper;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.dromara.hmily.common.utils.FileUtils;
import org.dromara.hmily.common.utils.StringUtils;
import org.dromara.hmily.config.api.Config;
import org.dromara.hmily.config.api.ConfigEnv;
import org.dromara.hmily.config.api.event.AddData;
import org.dromara.hmily.config.api.event.EventData;
import org.dromara.hmily.config.api.event.ModifyData;
import org.dromara.hmily.config.api.exception.ConfigException;
import org.dromara.hmily.config.loader.ConfigLoader;
import org.dromara.hmily.config.loader.PropertyLoader;
import org.dromara.hmily.config.loader.properties.PropertiesLoader;
import org.dromara.hmily.config.loader.property.PropertyKeySource;
import org.dromara.hmily.config.loader.yaml.YamlPropertyLoader;
import org.dromara.hmily.config.zookeeper.CuratorZookeeperClient;
import org.dromara.hmily.config.zookeeper.ZkPassiveConfig;
import org.dromara.hmily.config.zookeeper.ZookeeperConfig;
import org.dromara.hmily.spi.HmilySPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@HmilySPI(value="zookeeper")
public class ZookeeperConfigLoader
implements ConfigLoader<ZookeeperConfig> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZookeeperConfigLoader.class);
    private static final Map<String, PropertyLoader> LOADERS = new HashMap<String, PropertyLoader>();
    private CuratorZookeeperClient client;

    public ZookeeperConfigLoader() {
    }

    public ZookeeperConfigLoader(CuratorZookeeperClient client) {
        this();
        this.client = client;
    }

    public void passive(Supplier<ConfigLoader.Context> context, ConfigLoader.PassiveHandler<Config> handler, Config config) {
        if (config instanceof ZkPassiveConfig) {
            ZkPassiveConfig zkPassiveConfig = (ZkPassiveConfig)config;
            String value = zkPassiveConfig.getValue();
            if (StringUtils.isBlank((CharSequence)value)) {
                return;
            }
            PropertyLoader propertyLoader = LOADERS.get(zkPassiveConfig.getFileExtension());
            if (propertyLoader == null) {
                throw new ConfigException("nacos.fileExtension setting error, The loader was not found");
            }
            ByteArrayInputStream inputStream = new ByteArrayInputStream(value.getBytes());
            Optional.of(inputStream).map(e -> propertyLoader.load(zkPassiveConfig.fileName(), e)).ifPresent(e -> e.forEach(arg_0 -> this.lambda$null$4((Supplier)context, arg_0)));
        }
    }

    public void load(Supplier<ConfigLoader.Context> context, ConfigLoader.LoaderHandler<ZookeeperConfig> handler) {
        ConfigLoader.LoaderHandler zookeeperLoad = (c, config) -> this.zookeeperLoad(c, handler, (ZookeeperConfig)config);
        this.againLoad(context, zookeeperLoad, ZookeeperConfig.class);
    }

    private void zookeeperLoad(Supplier<ConfigLoader.Context> context, ConfigLoader.LoaderHandler<ZookeeperConfig> handler, ZookeeperConfig config) {
        if (config != null) {
            this.check(config);
            if (Objects.isNull(this.client)) {
                this.client = CuratorZookeeperClient.getInstance(config);
            }
            if (config.isUpdate()) {
                this.client.persist(config.getPath(), FileUtils.readYAML((String)config.getUpdateFileName()));
            }
            InputStream result = this.client.pull(config.getPath());
            String fileExtension = config.getFileExtension();
            PropertyLoader propertyLoader = LOADERS.get(fileExtension);
            if (propertyLoader == null) {
                throw new ConfigException("zookeeper.fileExtension setting error, The loader was not found");
            }
            Optional.ofNullable(result).map(e -> propertyLoader.load("remote.zookeeper." + fileExtension, e)).ifPresent(e -> ((ConfigLoader.Context)context.get()).getOriginal().load(() -> ZookeeperConfigLoader.lambda$null$8((Supplier)context, e), this::zookeeperFinish));
            handler.finish(context, (Config)config);
            try {
                this.client.addListener(context, (ConfigLoader.PassiveHandler<ZkPassiveConfig>)((ConfigLoader.PassiveHandler)(c1, c2) -> this.passive(c1, null, c2)), config);
            }
            catch (Exception e2) {
                LOGGER.error("passive zookeeper remote started error....");
            }
        } else {
            throw new ConfigException("zookeeper config is null");
        }
    }

    private void zookeeperFinish(Supplier<ConfigLoader.Context> context, Config config) {
        LOGGER.info("zookeeper loader config {}:{}", (Object)(config != null ? config.prefix() : ""), (Object)config);
    }

    private void check(ZookeeperConfig config) {
        if (StringUtils.isBlank((CharSequence)config.getServerList())) {
            throw new ConfigException("zookeeper server is null");
        }
    }

    private static /* synthetic */ ConfigLoader.Context lambda$null$8(Supplier context, List e) {
        return ((ConfigLoader.Context)context.get()).withSources(e);
    }

    private /* synthetic */ void lambda$null$4(Supplier context, PropertyKeySource x) {
        x.getKeys().forEach(arg_0 -> this.lambda$null$3(x, (Supplier)context, arg_0));
    }

    private /* synthetic */ void lambda$null$3(PropertyKeySource x, Supplier context, String t) {
        ConfigEnv.getInstance().stream().filter(c -> t.startsWith(c.prefix())).forEach(arg_0 -> this.lambda$null$2(t, x, (Supplier)context, arg_0));
    }

    private /* synthetic */ void lambda$null$2(String t, PropertyKeySource x, Supplier context, Config c) {
        Object o = c.getSource().get(t);
        AddData data = null;
        if (Objects.isNull(o)) {
            data = new AddData(t, x.getValue(t));
        } else if (!Objects.equals(o, x.getValue(t))) {
            data = new ModifyData(t, x.getValue(t));
        }
        this.push(context, (EventData)data);
    }

    static {
        LOADERS.put("yml", (PropertyLoader)new YamlPropertyLoader());
        LOADERS.put("properties", (PropertyLoader)new PropertiesLoader());
    }
}

