/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.config.zookeeper.handler;

import org.apache.zookeeper.KeeperException;
import org.dromara.hmily.config.api.exception.ConfigException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CuratorZookeeperExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(CuratorZookeeperExceptionHandler.class);

    public static void handleException(Exception cause) {
        if (null == cause) {
            return;
        }
        if (CuratorZookeeperExceptionHandler.isIgnoredException(cause) || null != cause.getCause() && CuratorZookeeperExceptionHandler.isIgnoredException(cause.getCause())) {
            log.debug("Ignored exception for: {}", (Object)cause.getMessage());
        } else if (cause instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        } else {
            throw new ConfigException((Throwable)cause);
        }
    }

    private static boolean isIgnoredException(Throwable cause) {
        return cause instanceof KeeperException.ConnectionLossException || cause instanceof KeeperException.NoNodeException || cause instanceof KeeperException.NodeExistsException;
    }

    private CuratorZookeeperExceptionHandler() {
    }
}

