/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.dubbo.loadbalance;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.rpc.Invoker;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.dromara.hmily.common.enums.HmilyActionEnum;
import org.dromara.hmily.core.context.HmilyContextHolder;
import org.dromara.hmily.core.context.HmilyTransactionContext;

public class HmilyLoadBalanceUtils {
    private static final Map<String, URL> URL_MAP = Maps.newConcurrentMap();

    public static <T> Invoker<T> doSelect(Invoker<T> defaultInvoker, List<Invoker<T>> invokers) {
        HmilyTransactionContext hmilyTransactionContext = HmilyContextHolder.get();
        if (Objects.isNull(hmilyTransactionContext)) {
            return defaultInvoker;
        }
        String key = defaultInvoker.getInterface().getName();
        if (hmilyTransactionContext.getAction() == HmilyActionEnum.TRYING.getCode()) {
            URL_MAP.put(key, defaultInvoker.getUrl());
            return defaultInvoker;
        }
        URL orlUrl = URL_MAP.get(key);
        URL_MAP.remove(key);
        if (Objects.nonNull(orlUrl)) {
            for (Invoker<T> inv : invokers) {
                if (!Objects.equals(inv.getUrl(), orlUrl)) continue;
                return inv;
            }
        }
        return defaultInvoker;
    }
}

