/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.motan.filter;

import com.weibo.api.motan.core.extension.Activation;
import com.weibo.api.motan.core.extension.SpiMeta;
import com.weibo.api.motan.filter.Filter;
import com.weibo.api.motan.rpc.Caller;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.Response;
import com.weibo.api.motan.util.ReflectUtil;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.dromara.hmily.annotation.Hmily;
import org.dromara.hmily.common.enums.HmilyActionEnum;
import org.dromara.hmily.common.enums.HmilyRoleEnum;
import org.dromara.hmily.common.exception.HmilyRuntimeException;
import org.dromara.hmily.common.utils.IdWorkerUtils;
import org.dromara.hmily.common.utils.LogUtil;
import org.dromara.hmily.core.context.HmilyContextHolder;
import org.dromara.hmily.core.context.HmilyTransactionContext;
import org.dromara.hmily.core.holder.HmilyTransactionHolder;
import org.dromara.hmily.core.mediator.RpcMediator;
import org.dromara.hmily.repository.spi.entity.HmilyInvocation;
import org.dromara.hmily.repository.spi.entity.HmilyParticipant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SpiMeta(name="motanHmilyTransactionFilter")
@Activation(key={"referer"})
public class MotanHmilyTransactionFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MotanHmilyTransactionFilter.class);

    public Response filter(Caller<?> caller, Request request) {
        HmilyTransactionContext context = HmilyContextHolder.get();
        if (Objects.isNull(context)) {
            return caller.call(request);
        }
        String interfaceName = request.getInterfaceName();
        String methodName = request.getMethodName();
        try {
            Class clazz = ReflectUtil.forName((String)interfaceName);
            Class<?>[] args = this.buildArgumentTypes(methodName, clazz);
            Method method = clazz.getMethod(methodName, args);
            Hmily hmily = method.getAnnotation(Hmily.class);
            if (Objects.isNull(hmily)) {
                return caller.call(request);
            }
        }
        catch (Exception e) {
            LogUtil.error((Logger)LOGGER, (String)"hmily find method error {} ", e::getMessage);
            return caller.call(request);
        }
        Long participantId = context.getParticipantId();
        HmilyParticipant hmilyParticipant = this.buildParticipant(context, request);
        Optional.ofNullable(hmilyParticipant).ifPresent(participant -> context.setParticipantId(participant.getParticipantId()));
        if (context.getRole() == HmilyRoleEnum.PARTICIPANT.getCode()) {
            context.setParticipantRefId(participantId);
        }
        RpcMediator.getInstance().transmit((arg_0, arg_1) -> ((Request)request).setAttachment(arg_0, arg_1), context);
        Response response = caller.call(request);
        if (null == response.getException()) {
            if (context.getRole() == HmilyRoleEnum.PARTICIPANT.getCode()) {
                HmilyTransactionHolder.getInstance().registerParticipantByNested(participantId, hmilyParticipant);
            } else {
                HmilyTransactionHolder.getInstance().registerStarterParticipant(hmilyParticipant);
            }
        } else {
            throw new HmilyRuntimeException("motan rpc invoke exception{}", (Throwable)response.getException());
        }
        return response;
    }

    private HmilyParticipant buildParticipant(HmilyTransactionContext context, Request request) throws HmilyRuntimeException {
        if (HmilyActionEnum.TRYING.getCode() != context.getAction()) {
            return null;
        }
        HmilyParticipant hmilyParticipant = new HmilyParticipant();
        hmilyParticipant.setTransId(context.getTransId());
        hmilyParticipant.setTransType(context.getTransType());
        hmilyParticipant.setParticipantId(Long.valueOf(IdWorkerUtils.getInstance().createUUID()));
        String methodName = request.getMethodName();
        Object[] arguments = request.getArguments();
        String interfaceName = request.getInterfaceName();
        Class clazz = ReflectUtil.forName((String)interfaceName);
        Class[] args = this.buildArgumentTypes(methodName, clazz);
        HmilyInvocation hmilyInvocation = new HmilyInvocation(clazz, methodName, args, arguments);
        hmilyParticipant.setConfirmHmilyInvocation(hmilyInvocation);
        hmilyParticipant.setCancelHmilyInvocation(hmilyInvocation);
        return hmilyParticipant;
    }

    private Class<?>[] buildArgumentTypes(String methodName, Class<?> clazz) {
        Method[] methods = clazz.getMethods();
        return Stream.of(methods).filter(m -> m.getName().equals(methodName)).findFirst().map(Method::getParameterTypes).get();
    }
}

