/*
 * Copyright 2017-2021 Dromara.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.dromara.hmily.tac.sqlparser.model.common.segment.dml.item;

import lombok.Getter;
import lombok.Setter;
import org.dromara.hmily.tac.sqlparser.model.common.segment.dml.column.HmilyColumnSegment;
import org.dromara.hmily.tac.sqlparser.model.common.segment.generic.HmilyAliasAvailable;
import org.dromara.hmily.tac.sqlparser.model.common.segment.generic.HmilyAliasSegment;

import java.util.Optional;

/**
 * Column projection segment.
 */
public final class HmilyColumnProjectionSegment implements HmilyProjectionSegment, HmilyAliasAvailable {
    
    @Getter
    private final HmilyColumnSegment column;
    
    @Setter
    private HmilyAliasSegment alias;
    
    public HmilyColumnProjectionSegment(final HmilyColumnSegment hmilyColumnSegment) {
        column = hmilyColumnSegment;
    }
    
    @Override
    public Optional<String> getAlias() {
        return null == alias ? Optional.empty() : Optional.ofNullable(alias.getIdentifier().getValue());
    }
    
    @Override
    public int getStartIndex() {
        return column.getStartIndex();
    }
    
    @Override
    public int getStopIndex() {
        return column.getStopIndex();
        // TODO
        // return null == alias ? alias.getStopIndex() : column.getStopIndex();
    }
}
