/*
 * Copyright 2017-2021 Dromara.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.dromara.hmily.tac.sqlparser.model.common.segment.generic.table;

import lombok.Getter;
import lombok.Setter;
import org.dromara.hmily.tac.sqlparser.model.common.segment.dml.column.HmilyColumnSegment;
import org.dromara.hmily.tac.sqlparser.model.common.segment.dml.expr.HmilyExpressionSegment;
import org.dromara.hmily.tac.sqlparser.model.common.segment.generic.HmilyAliasSegment;

import java.util.List;
import java.util.Optional;

@Getter
@Setter
public final class HmilyJoinTableSegment implements HmilyTableSegment {
    
    private int startIndex;
    
    private int stopIndex;
    
    private HmilyAliasSegment alias;
    
    private HmilyTableSegment left;
    
    private String joinType;
    
    private HmilyTableSegment right;
    
    private List<HmilyColumnSegment> using;
    
    private HmilyExpressionSegment condition;
    
    @Override
    public Optional<String> getAlias() {
        return null == alias ? Optional.empty() : Optional.ofNullable(alias.getIdentifier().getValue());
    }
}
