/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.tac.sqlparser.model.common.constant;

import java.util.Arrays;

public enum HmilyParen {
    PARENTHESES('(', ')'),
    BRACKET('[', ']'),
    BRACES('{', '}');

    private final char leftParen;
    private final char rightParen;

    public static boolean isLeftParen(char token) {
        return Arrays.stream(HmilyParen.values()).anyMatch(each -> each.leftParen == token);
    }

    public static boolean match(char leftToken, char rightToken) {
        for (HmilyParen each : HmilyParen.values()) {
            if (each.leftParen != leftToken || each.rightParen != rightToken) continue;
            return true;
        }
        return false;
    }

    private HmilyParen(char leftParen, char rightParen) {
        this.leftParen = leftParen;
        this.rightParen = rightParen;
    }

    public char getLeftParen() {
        return this.leftParen;
    }

    public char getRightParen() {
        return this.rightParen;
    }
}

