/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.tac.sqlparser.model.common.constant;

import com.google.common.base.Strings;
import java.util.Arrays;

public enum HmilyQuoteCharacter {
    BACK_QUOTE("`", "`"),
    SINGLE_QUOTE("'", "'"),
    QUOTE("\"", "\""),
    BRACKETS("[", "]"),
    NONE("", "");

    private final String startDelimiter;
    private final String endDelimiter;

    public static HmilyQuoteCharacter getQuoteCharacter(String value) {
        if (Strings.isNullOrEmpty((String)value)) {
            return NONE;
        }
        return Arrays.stream(HmilyQuoteCharacter.values()).filter(each -> NONE != each && each.startDelimiter.charAt(0) == value.charAt(0)).findFirst().orElse(NONE);
    }

    public String wrap(String value) {
        return String.format("%s%s%s", this.startDelimiter, value, this.endDelimiter);
    }

    private HmilyQuoteCharacter(String startDelimiter, String endDelimiter) {
        this.startDelimiter = startDelimiter;
        this.endDelimiter = endDelimiter;
    }

    public String getStartDelimiter() {
        return this.startDelimiter;
    }

    public String getEndDelimiter() {
        return this.endDelimiter;
    }
}

