/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.tac.sqlparser.model.common.util;

import java.util.Optional;
import org.dromara.hmily.tac.sqlparser.model.common.constant.HmilyLogicalOperator;
import org.dromara.hmily.tac.sqlparser.model.common.segment.dml.expr.HmilyBinaryOperationExpression;
import org.dromara.hmily.tac.sqlparser.model.common.segment.dml.expr.HmilyExpressionSegment;
import org.dromara.hmily.tac.sqlparser.model.common.segment.dml.predicate.HmilyAndPredicate;
import org.dromara.hmily.tac.sqlparser.model.common.segment.dml.predicate.HmilyOrPredicateSegment;

public final class HmilyExpressionBuilder {
    private final HmilyExpressionSegment expression;

    public HmilyOrPredicateSegment extractAndPredicates() {
        HmilyOrPredicateSegment result = new HmilyOrPredicateSegment();
        if (this.expression instanceof HmilyBinaryOperationExpression) {
            String operator = ((HmilyBinaryOperationExpression)this.expression).getOperator();
            Optional<HmilyLogicalOperator> logicalOperator = HmilyLogicalOperator.valueFrom(operator);
            if (logicalOperator.isPresent() && HmilyLogicalOperator.OR == logicalOperator.get()) {
                HmilyExpressionBuilder leftBuilder = new HmilyExpressionBuilder(((HmilyBinaryOperationExpression)this.expression).getLeft());
                HmilyExpressionBuilder rightBuilder = new HmilyExpressionBuilder(((HmilyBinaryOperationExpression)this.expression).getRight());
                result.getHmilyAndPredicates().addAll(leftBuilder.extractAndPredicates().getHmilyAndPredicates());
                result.getHmilyAndPredicates().addAll(rightBuilder.extractAndPredicates().getHmilyAndPredicates());
            } else if (logicalOperator.isPresent() && HmilyLogicalOperator.AND == logicalOperator.get()) {
                HmilyExpressionBuilder leftBuilder = new HmilyExpressionBuilder(((HmilyBinaryOperationExpression)this.expression).getLeft());
                HmilyExpressionBuilder rightBuilder = new HmilyExpressionBuilder(((HmilyBinaryOperationExpression)this.expression).getRight());
                for (HmilyAndPredicate eachLeft : leftBuilder.extractAndPredicates().getHmilyAndPredicates()) {
                    for (HmilyAndPredicate eachRight : rightBuilder.extractAndPredicates().getHmilyAndPredicates()) {
                        result.getHmilyAndPredicates().add(this.createAndPredicate(eachLeft, eachRight));
                    }
                }
            } else {
                HmilyAndPredicate andPredicate = new HmilyAndPredicate();
                andPredicate.getPredicates().add(this.expression);
                result.getHmilyAndPredicates().add(andPredicate);
            }
        } else {
            HmilyAndPredicate andPredicate = new HmilyAndPredicate();
            andPredicate.getPredicates().add(this.expression);
            result.getHmilyAndPredicates().add(andPredicate);
        }
        return result;
    }

    private HmilyAndPredicate createAndPredicate(HmilyAndPredicate left, HmilyAndPredicate right) {
        HmilyAndPredicate result = new HmilyAndPredicate();
        result.getPredicates().addAll(left.getPredicates());
        result.getPredicates().addAll(right.getPredicates());
        return result;
    }

    public HmilyExpressionBuilder(HmilyExpressionSegment expression) {
        this.expression = expression;
    }
}

