/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.tac.sqlparser.model.common.util;

import com.google.common.base.CharMatcher;
import com.google.common.base.Strings;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.dromara.hmily.tac.sqlparser.model.common.constant.HmilyParen;
import org.dromara.hmily.tac.sqlparser.model.common.statement.HmilyStatement;
import org.dromara.hmily.tac.sqlparser.model.common.statement.dml.HmilyDMLStatement;
import org.dromara.hmily.tac.sqlparser.model.common.statement.dml.HmilyDeleteStatement;
import org.dromara.hmily.tac.sqlparser.model.common.statement.dml.HmilyInsertStatement;
import org.dromara.hmily.tac.sqlparser.model.common.statement.dml.HmilyUpdateStatement;

public final class HmilySQLUtil {
    public static Number getExactlyNumber(String value, int radix) {
        try {
            return HmilySQLUtil.getBigInteger(value, radix);
        }
        catch (NumberFormatException ex) {
            return new BigDecimal(value);
        }
    }

    private static Number getBigInteger(String value, int radix) {
        BigInteger result = new BigInteger(value, radix);
        if (result.compareTo(new BigInteger(String.valueOf(Integer.MIN_VALUE))) >= 0 && result.compareTo(new BigInteger(String.valueOf(Integer.MAX_VALUE))) <= 0) {
            return result.intValue();
        }
        if (result.compareTo(new BigInteger(String.valueOf(Long.MIN_VALUE))) >= 0 && result.compareTo(new BigInteger(String.valueOf(Long.MAX_VALUE))) <= 0) {
            return result.longValue();
        }
        return result;
    }

    public static String getExactlyValue(String value) {
        return null == value ? null : CharMatcher.anyOf((CharSequence)"[]`'\"").removeFrom((CharSequence)value);
    }

    public static String getExactlyExpression(String value) {
        return Strings.isNullOrEmpty((String)value) ? value : CharMatcher.anyOf((CharSequence)" ").removeFrom((CharSequence)value);
    }

    public static String getExpressionWithoutOutsideParentheses(String value) {
        int parenthesesOffset = HmilySQLUtil.getParenthesesOffset(value);
        return 0 == parenthesesOffset ? value : value.substring(parenthesesOffset, value.length() - parenthesesOffset);
    }

    private static int getParenthesesOffset(String value) {
        int result = 0;
        if (Strings.isNullOrEmpty((String)value)) {
            return result;
        }
        while (HmilyParen.PARENTHESES.getLeftParen() == value.charAt(result)) {
            ++result;
        }
        return result;
    }

    public static boolean isReadOnly(HmilyStatement sqlStatement) {
        if (sqlStatement instanceof HmilyDMLStatement) {
            return HmilySQLUtil.isReadOnly((HmilyDMLStatement)sqlStatement);
        }
        throw new UnsupportedOperationException(String.format("Unsupported SQL Type `%s`", sqlStatement.getClass().getSimpleName()));
    }

    private static boolean isReadOnly(HmilyDMLStatement sqlStatement) {
        if (sqlStatement instanceof HmilyUpdateStatement || sqlStatement instanceof HmilyDeleteStatement || sqlStatement instanceof HmilyInsertStatement) {
            return false;
        }
        throw new UnsupportedOperationException(String.format("Unsupported SQL Type `%s`", sqlStatement.getClass().getSimpleName()));
    }

    private HmilySQLUtil() {
    }
}

