/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.tac.sqlparser.model.common.value.literal.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.dromara.hmily.tac.sqlparser.model.common.value.literal.HmilyLiteralValue;

public final class HmilyNumberLiteralValue
implements HmilyLiteralValue<Number> {
    private final Number value;

    public HmilyNumberLiteralValue(String value) {
        this.value = this.getNumber(value);
    }

    private Number getNumber(String value) {
        try {
            return HmilyNumberLiteralValue.getBigInteger(value);
        }
        catch (NumberFormatException ex) {
            return new BigDecimal(value);
        }
    }

    private static Number getBigInteger(String value) {
        BigInteger result = new BigInteger(value);
        if (result.compareTo(new BigInteger(String.valueOf(Integer.MIN_VALUE))) >= 0 && result.compareTo(new BigInteger(String.valueOf(Integer.MAX_VALUE))) <= 0) {
            return result.intValue();
        }
        if (result.compareTo(new BigInteger(String.valueOf(Long.MIN_VALUE))) >= 0 && result.compareTo(new BigInteger(String.valueOf(Long.MAX_VALUE))) <= 0) {
            return result.longValue();
        }
        return result;
    }

    @Override
    public Number getValue() {
        return this.value;
    }
}

