/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.convert.impl;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Map;
import org.dromara.hutool.core.bean.BeanUtil;
import org.dromara.hutool.core.bean.copier.ValueProvider;
import org.dromara.hutool.core.bean.copier.provider.BeanValueProvider;
import org.dromara.hutool.core.bean.copier.provider.MapValueProvider;
import org.dromara.hutool.core.convert.ConvertException;
import org.dromara.hutool.core.convert.Converter;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.reflect.TypeUtil;
import org.dromara.hutool.core.reflect.kotlin.KClassUtil;

public class KBeanConverter
implements Converter,
Serializable {
    private static final long serialVersionUID = 1L;
    public static KBeanConverter INSTANCE = new KBeanConverter();

    @Override
    public Object convert(Type targetType, Object value) throws ConvertException {
        Assert.notNull(targetType);
        if (null == value) {
            return null;
        }
        if (value instanceof Converter) {
            return ((Converter)value).convert(targetType, value);
        }
        Class<?> targetClass = TypeUtil.getClass(targetType);
        Assert.notNull(targetClass, "Target type is not a class!", new Object[0]);
        return this.convertInternal(targetType, targetClass, value);
    }

    private Object convertInternal(Type targetType, Class<?> targetClass, Object value) {
        ValueProvider valueProvider = null;
        if (value instanceof ValueProvider) {
            valueProvider = (ValueProvider)value;
        } else if (value instanceof Map) {
            valueProvider = new MapValueProvider((Map)value);
        } else if (BeanUtil.isWritableBean(value.getClass())) {
            valueProvider = new BeanValueProvider(value);
        }
        if (null != valueProvider) {
            return KClassUtil.newInstance(targetClass, valueProvider);
        }
        throw new ConvertException("Unsupported source type: [{}] to [{}]", value.getClass(), targetType);
    }
}

