/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.date.format.parser;

import java.io.Serializable;
import java.util.regex.Pattern;
import org.dromara.hutool.core.date.DateException;
import org.dromara.hutool.core.date.DatePattern;
import org.dromara.hutool.core.date.DateTime;
import org.dromara.hutool.core.date.format.parser.PredicateDateParser;
import org.dromara.hutool.core.regex.ReUtil;
import org.dromara.hutool.core.text.StrUtil;

public class NormalDateParser
implements PredicateDateParser,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Pattern patternNorm = Pattern.compile("\\d{4}-\\d{1,2}-\\d{1,2}(\\s\\d{1,2}:\\d{1,2}(:\\d{1,2})?(.\\d{1,6})?)?");
    public static NormalDateParser INSTANCE = new NormalDateParser();

    @Override
    public boolean test(CharSequence dateStr) {
        return ReUtil.isMatch(patternNorm, dateStr);
    }

    @Override
    public DateTime parse(CharSequence source) throws DateException {
        int colonCount = StrUtil.count(source, ':');
        switch (colonCount) {
            case 0: {
                return new DateTime(source, DatePattern.NORM_DATE_FORMAT);
            }
            case 1: {
                return new DateTime(source, DatePattern.NORM_DATETIME_MINUTE_FORMAT);
            }
            case 2: {
                int indexOfDot = StrUtil.indexOf(source, '.');
                if (indexOfDot > 0) {
                    int length1 = source.length();
                    if (length1 - indexOfDot > 4) {
                        source = StrUtil.subPre(source, indexOfDot + 4);
                    }
                    return new DateTime(source, DatePattern.NORM_DATETIME_MS_FORMAT);
                }
                return new DateTime(source, DatePattern.NORM_DATETIME_FORMAT);
            }
        }
        throw new DateException("No format fit for date String [{}] !", source);
    }
}

