/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.exception.HutoolException;
import org.dromara.hutool.core.reflect.ModifierType;
import org.dromara.hutool.core.reflect.ReflectUtil;

public class ModifierUtil {
    public static boolean hasModifier(Class<?> clazz, ModifierType ... modifierTypes) {
        if (null == clazz || ArrayUtil.isEmpty(modifierTypes)) {
            return false;
        }
        return 0 != (clazz.getModifiers() & ModifierType.orToInt(modifierTypes));
    }

    public static boolean hasModifier(Member member, ModifierType ... modifierTypes) {
        if (null == member || ArrayUtil.isEmpty(modifierTypes)) {
            return false;
        }
        return 0 != (member.getModifiers() & ModifierType.orToInt(modifierTypes));
    }

    public static boolean hasModifier(int modifiers, int ... checkedModifiers) {
        if (ArrayUtil.isEmpty(checkedModifiers)) {
            return false;
        }
        return 0 != (modifiers & ModifierType.orToInt(checkedModifiers));
    }

    public static boolean hasAllModifier(int modifiers, int ... checkedModifiers) {
        if (ArrayUtil.isEmpty(checkedModifiers)) {
            return false;
        }
        int checkedModifiersInt = ModifierType.orToInt(checkedModifiers);
        return checkedModifiersInt == (modifiers & checkedModifiersInt);
    }

    public static boolean isDefault(Method method) {
        return null != method && method.isDefault();
    }

    public static boolean isPublic(Member member) {
        return null != member && Modifier.isPublic(member.getModifiers());
    }

    public static boolean isPublic(Class<?> clazz) {
        return null != clazz && Modifier.isPublic(clazz.getModifiers());
    }

    public static boolean isPrivate(Member member) {
        return null != member && Modifier.isPrivate(member.getModifiers());
    }

    public static boolean isPrivate(Class<?> clazz) {
        return null != clazz && Modifier.isPrivate(clazz.getModifiers());
    }

    public static boolean isStatic(Member member) {
        return null != member && Modifier.isStatic(member.getModifiers());
    }

    public static boolean isStatic(Class<?> clazz) {
        return null != clazz && Modifier.isStatic(clazz.getModifiers());
    }

    public static boolean isSynthetic(Member member) {
        return null != member && member.isSynthetic();
    }

    public static boolean isSynthetic(Class<?> clazz) {
        return null != clazz && clazz.isSynthetic();
    }

    public static boolean isAbstract(Member member) {
        return null != member && Modifier.isAbstract(member.getModifiers());
    }

    public static boolean isAbstract(Class<?> clazz) {
        return null != clazz && Modifier.isAbstract(clazz.getModifiers());
    }

    public static boolean isInterface(Class<?> clazz) {
        return null != clazz && clazz.isInterface();
    }

    public static void removeFinalModify(Field field) {
        Field modifiersField;
        if (!ModifierUtil.hasModifier(field, ModifierType.FINAL)) {
            return;
        }
        ReflectUtil.setAccessible(field);
        try {
            modifiersField = Field.class.getDeclaredField("modifiers");
        }
        catch (NoSuchFieldException e) {
            throw new HutoolException(e, "Field [modifiers] not exist!", new Object[0]);
        }
        try {
            modifiersField.setAccessible(true);
            modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        }
        catch (IllegalAccessException e) {
            throw new HutoolException(e, "IllegalAccess for [{}.{}]", field.getDeclaringClass(), field.getName());
        }
    }
}

