/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.reflect.method;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.dromara.hutool.core.exception.HutoolException;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.reflect.ClassUtil;
import org.dromara.hutool.core.reflect.Invoker;
import org.dromara.hutool.core.reflect.ModifierUtil;
import org.dromara.hutool.core.reflect.method.MethodHandleUtil;
import org.dromara.hutool.core.reflect.method.MethodUtil;

public class MethodInvoker
implements Invoker {
    private final Method method;
    private final Class<?>[] paramTypes;
    private final Class<?> type;
    private boolean checkArgs;

    public static MethodInvoker of(Method method) {
        return new MethodInvoker(method);
    }

    public MethodInvoker(Method method) {
        this.method = method;
        this.paramTypes = method.getParameterTypes();
        this.type = this.paramTypes.length == 1 ? this.paramTypes[0] : method.getReturnType();
    }

    public MethodInvoker setCheckArgs(boolean checkArgs) {
        this.checkArgs = checkArgs;
        return this;
    }

    @Override
    public <T> T invoke(Object target, Object ... args) throws HutoolException {
        Method method;
        if (this.checkArgs) {
            this.checkArgs(args);
        }
        if (ModifierUtil.isStatic(method = this.method)) {
            target = null;
        }
        Object[] actualArgs = MethodUtil.actualArgs(method, args);
        try {
            return MethodHandleUtil.invokeExact(target, method, actualArgs);
        }
        catch (Exception e) {
            try {
                return (T)method.invoke(target, actualArgs);
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                throw new HutoolException(ex);
            }
        }
    }

    public <T> T invokeStatic(Object ... args) throws HutoolException {
        return this.invoke(null, args);
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    private void checkArgs(Object[] args) {
        Class<?>[] paramTypes = this.paramTypes;
        if (null != args) {
            Assert.isTrue(args.length == paramTypes.length, "Params length [{}] is not fit for param length [{}] of method !", args.length, paramTypes.length);
            for (int i = 0; i < args.length; ++i) {
                Class<?> type = paramTypes[i];
                if (!type.isPrimitive() || null != args[i]) continue;
                args[i] = ClassUtil.getDefaultValue(type);
            }
        }
    }
}

