/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.text;

import java.util.Arrays;
import java.util.Iterator;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.collection.iter.ArrayIter;

public class CharArray
implements CharSequence,
Iterable<Character> {
    private final char[] value;

    public CharArray(String value) {
        this(value.toCharArray(), false);
    }

    public CharArray(char[] value, boolean copy) {
        this.value = copy ? (char[])value.clone() : value;
    }

    @Override
    public int length() {
        return this.value.length;
    }

    @Override
    public char charAt(int index) {
        if (index < 0) {
            index += this.value.length;
        }
        return this.value[index];
    }

    public CharArray set(int index, char c) {
        if (index < 0) {
            index += this.value.length;
        }
        this.value[index] = c;
        return this;
    }

    public char[] array() {
        return this.value;
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return new CharArray(ArrayUtil.sub(this.value, start, end), false);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CharArray charArray = (CharArray)o;
        return Arrays.equals(this.value, charArray.value);
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    @Override
    public Iterator<Character> iterator() {
        return new ArrayIter<Character>((Object)this.value);
    }

    @Override
    public String toString() {
        return String.valueOf(this.value);
    }
}

