/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAdder;
import org.dromara.hutool.core.io.buffer.FastByteBuffer;
import org.dromara.hutool.core.math.NumberUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.CharsetUtil;

public class ByteUtil {
    public static final ByteOrder DEFAULT_ORDER = ByteOrder.LITTLE_ENDIAN;
    public static final ByteOrder CPU_ENDIAN = "little".equals(System.getProperty("sun.cpu.endian")) ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;

    public static byte[] toUtf8Bytes(CharSequence str) {
        return ByteUtil.toBytes(str, CharsetUtil.UTF_8);
    }

    public static byte[] toBytes(CharSequence str, Charset charset) {
        if (str == null) {
            return null;
        }
        if (null == charset) {
            return str.toString().getBytes();
        }
        return str.toString().getBytes(charset);
    }

    public static byte toByte(int intValue) {
        return (byte)intValue;
    }

    public static byte[] toBytes(short shortValue) {
        return ByteUtil.toBytes(shortValue, DEFAULT_ORDER);
    }

    public static byte[] toBytes(short shortValue, ByteOrder byteOrder) {
        byte[] b = new byte[2];
        if (ByteOrder.LITTLE_ENDIAN == byteOrder) {
            b[0] = (byte)(shortValue & 0xFF);
            b[1] = (byte)(shortValue >> 8 & 0xFF);
        } else {
            b[1] = (byte)(shortValue & 0xFF);
            b[0] = (byte)(shortValue >> 8 & 0xFF);
        }
        return b;
    }

    public static byte[] toBytes(int intValue) {
        return ByteUtil.toBytes(intValue, DEFAULT_ORDER);
    }

    public static byte[] toBytes(int intValue, ByteOrder byteOrder) {
        if (ByteOrder.LITTLE_ENDIAN == byteOrder) {
            return new byte[]{(byte)(intValue & 0xFF), (byte)(intValue >> 8 & 0xFF), (byte)(intValue >> 16 & 0xFF), (byte)(intValue >> 24 & 0xFF)};
        }
        return new byte[]{(byte)(intValue >> 24 & 0xFF), (byte)(intValue >> 16 & 0xFF), (byte)(intValue >> 8 & 0xFF), (byte)(intValue & 0xFF)};
    }

    public static byte[] toBytes(long longValue) {
        return ByteUtil.toBytes(longValue, DEFAULT_ORDER);
    }

    public static byte[] toBytes(long longValue, ByteOrder byteOrder) {
        byte[] result = new byte[8];
        return ByteUtil.fill(longValue, 0, byteOrder, result);
    }

    public static byte[] fill(long longValue, int start, ByteOrder byteOrder, byte[] bytes) {
        if (ByteOrder.LITTLE_ENDIAN == byteOrder) {
            for (int i = start; i < bytes.length; ++i) {
                bytes[i] = (byte)(longValue & 0xFFL);
                longValue >>= 8;
            }
        } else {
            for (int i = bytes.length - 1; i >= start; --i) {
                bytes[i] = (byte)(longValue & 0xFFL);
                longValue >>= 8;
            }
        }
        return bytes;
    }

    public static byte[] toBytes(float floatValue) {
        return ByteUtil.toBytes(floatValue, DEFAULT_ORDER);
    }

    public static byte[] toBytes(float floatValue, ByteOrder byteOrder) {
        return ByteUtil.toBytes(Float.floatToIntBits(floatValue), byteOrder);
    }

    public static byte[] toBytes(double doubleValue) {
        return ByteUtil.toBytes(doubleValue, DEFAULT_ORDER);
    }

    public static byte[] toBytes(double doubleValue, ByteOrder byteOrder) {
        return ByteUtil.toBytes(Double.doubleToLongBits(doubleValue), byteOrder);
    }

    public static byte[] toBytes(Number number) {
        return ByteUtil.toBytes(number, DEFAULT_ORDER);
    }

    public static byte[] toBytes(Number number, ByteOrder byteOrder) {
        if (number instanceof Byte) {
            return new byte[]{number.byteValue()};
        }
        if (number instanceof Double) {
            return ByteUtil.toBytes(number.doubleValue(), byteOrder);
        }
        if (number instanceof Long) {
            return ByteUtil.toBytes(number.longValue(), byteOrder);
        }
        if (number instanceof Integer) {
            return ByteUtil.toBytes(number.intValue(), byteOrder);
        }
        if (number instanceof Short) {
            return ByteUtil.toBytes(number.shortValue(), byteOrder);
        }
        if (number instanceof Float) {
            return ByteUtil.toBytes(number.floatValue(), byteOrder);
        }
        if (number instanceof BigInteger) {
            return ((BigInteger)number).toByteArray();
        }
        return ByteUtil.toBytes(number.doubleValue(), byteOrder);
    }

    public static short toShort(byte[] bytes) {
        return ByteUtil.toShort(bytes, DEFAULT_ORDER);
    }

    public static short toShort(byte[] bytes, ByteOrder byteOrder) {
        return ByteUtil.toShort(bytes, 0, byteOrder);
    }

    public static short toShort(byte[] bytes, int start, ByteOrder byteOrder) {
        if (ByteOrder.LITTLE_ENDIAN == byteOrder) {
            return (short)(bytes[start] & 0xFF | (bytes[start + 1] & 0xFF) << 8);
        }
        return (short)(bytes[start + 1] & 0xFF | (bytes[start] & 0xFF) << 8);
    }

    public static int toInt(byte[] bytes) {
        return ByteUtil.toInt(bytes, DEFAULT_ORDER);
    }

    public static int toInt(byte[] bytes, ByteOrder byteOrder) {
        return ByteUtil.toInt(bytes, 0, byteOrder);
    }

    public static int toInt(byte[] bytes, int start, ByteOrder byteOrder) {
        if (ByteOrder.LITTLE_ENDIAN == byteOrder) {
            return bytes[start] & 0xFF | (bytes[1 + start] & 0xFF) << 8 | (bytes[2 + start] & 0xFF) << 16 | (bytes[3 + start] & 0xFF) << 24;
        }
        return bytes[3 + start] & 0xFF | (bytes[2 + start] & 0xFF) << 8 | (bytes[1 + start] & 0xFF) << 16 | (bytes[start] & 0xFF) << 24;
    }

    public static int toUnsignedInt(byte byteValue) {
        return byteValue & 0xFF;
    }

    public static long toLong(byte[] bytes) {
        return ByteUtil.toLong(bytes, DEFAULT_ORDER);
    }

    public static long toLong(byte[] bytes, ByteOrder byteOrder) {
        return ByteUtil.toLong(bytes, 0, byteOrder);
    }

    public static long toLong(byte[] bytes, int start, ByteOrder byteOrder) {
        long values = 0L;
        if (ByteOrder.LITTLE_ENDIAN == byteOrder) {
            for (int i = 7; i >= 0; --i) {
                values <<= 8;
                values |= (long)bytes[i + start] & 0xFFL;
            }
        } else {
            for (int i = 0; i < 8; ++i) {
                values <<= 8;
                values |= (long)bytes[i + start] & 0xFFL;
            }
        }
        return values;
    }

    public static float toFloat(byte[] bytes) {
        return ByteUtil.toFloat(bytes, DEFAULT_ORDER);
    }

    public static float toFloat(byte[] bytes, ByteOrder byteOrder) {
        return Float.intBitsToFloat(ByteUtil.toInt(bytes, byteOrder));
    }

    public static double toDouble(byte[] bytes) {
        return ByteUtil.toDouble(bytes, DEFAULT_ORDER);
    }

    public static double toDouble(byte[] bytes, ByteOrder byteOrder) {
        return Double.longBitsToDouble(ByteUtil.toLong(bytes, byteOrder));
    }

    public static <T extends Number> T toNumber(byte[] bytes, Class<T> targetClass, ByteOrder byteOrder) throws IllegalArgumentException {
        Number number;
        if (Byte.class == targetClass) {
            number = bytes[0];
        } else if (Short.class == targetClass) {
            number = ByteUtil.toShort(bytes, byteOrder);
        } else if (Integer.class == targetClass) {
            number = ByteUtil.toInt(bytes, byteOrder);
        } else if (AtomicInteger.class == targetClass) {
            number = new AtomicInteger(ByteUtil.toInt(bytes, byteOrder));
        } else if (Long.class == targetClass) {
            number = ByteUtil.toLong(bytes, byteOrder);
        } else if (AtomicLong.class == targetClass) {
            number = new AtomicLong(ByteUtil.toLong(bytes, byteOrder));
        } else if (LongAdder.class == targetClass) {
            LongAdder longValue = new LongAdder();
            longValue.add(ByteUtil.toLong(bytes, byteOrder));
            number = longValue;
        } else if (Float.class == targetClass) {
            number = Float.valueOf(ByteUtil.toFloat(bytes, byteOrder));
        } else if (Double.class == targetClass) {
            number = ByteUtil.toDouble(bytes, byteOrder);
        } else if (DoubleAdder.class == targetClass) {
            DoubleAdder doubleAdder = new DoubleAdder();
            doubleAdder.add(ByteUtil.toDouble(bytes, byteOrder));
            number = doubleAdder;
        } else if (BigDecimal.class == targetClass) {
            number = NumberUtil.toBigDecimal(ByteUtil.toDouble(bytes, byteOrder));
        } else if (BigInteger.class == targetClass) {
            number = BigInteger.valueOf(ByteUtil.toLong(bytes, byteOrder));
        } else if (Number.class == targetClass) {
            number = ByteUtil.toDouble(bytes, byteOrder);
        } else {
            throw new IllegalArgumentException("Unsupported Number type: " + targetClass.getName());
        }
        return (T)number;
    }

    public static byte[] toUnsignedByteArray(BigInteger value) {
        byte[] bytes = value.toByteArray();
        if (bytes[0] == 0) {
            byte[] tmp = new byte[bytes.length - 1];
            System.arraycopy(bytes, 1, tmp, 0, tmp.length);
            return tmp;
        }
        return bytes;
    }

    public static byte[] toUnsignedByteArray(int length, BigInteger value) {
        byte[] bytes = value.toByteArray();
        if (bytes.length == length) {
            return bytes;
        }
        int start = bytes[0] == 0 ? 1 : 0;
        int count = bytes.length - start;
        if (count > length) {
            throw new IllegalArgumentException("standard length exceeded for value");
        }
        byte[] tmp = new byte[length];
        System.arraycopy(bytes, start, tmp, tmp.length - count, count);
        return tmp;
    }

    public static BigInteger fromUnsignedByteArray(byte[] buf) {
        return new BigInteger(1, buf);
    }

    public static BigInteger fromUnsignedByteArray(byte[] buf, int off, int length) {
        byte[] mag = buf;
        if (off != 0 || length != buf.length) {
            mag = new byte[length];
            System.arraycopy(buf, off, mag, 0, length);
        }
        return new BigInteger(1, mag);
    }

    public static byte[] concat(byte[] ... byteArrays) {
        int totalLength = 0;
        for (byte[] byteArray : byteArrays) {
            totalLength += byteArray.length;
        }
        FastByteBuffer buffer = new FastByteBuffer(totalLength);
        for (byte[] byteArray : byteArrays) {
            buffer.append(byteArray);
        }
        return buffer.toArrayZeroCopyIfPossible();
    }

    public static int bitCount(byte[] buf) {
        int sum = 0;
        for (byte b : buf) {
            sum += Integer.bitCount(b & 0xFF);
        }
        return sum;
    }

    public static List<Integer> toUnsignedBitIndex(byte[] bytes) {
        LinkedList<Integer> idxList = new LinkedList<Integer>();
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(StrUtil.padPre((CharSequence)Integer.toBinaryString(b & 0xFF), 8, "0"));
        }
        String bitStr = sb.toString();
        for (int i = 0; i < bitStr.length(); ++i) {
            if (bitStr.charAt(i) != '1') continue;
            idxList.add(i);
        }
        return idxList;
    }
}

