/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db.ds.tomcat;

import java.util.Properties;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.apache.tomcat.jdbc.pool.PoolConfiguration;
import org.apache.tomcat.jdbc.pool.PoolProperties;
import org.dromara.hutool.core.map.MapUtil;
import org.dromara.hutool.db.config.ConnectionConfig;
import org.dromara.hutool.db.ds.AbstractDSFactory;
import org.dromara.hutool.setting.props.Props;

public class TomcatDSFactory
extends AbstractDSFactory {
    private static final long serialVersionUID = 1L;

    public TomcatDSFactory() {
        super(DataSource.class, "Tomcat-Jdbc-Pool");
    }

    @Override
    public javax.sql.DataSource createDataSource(ConnectionConfig<?> config) {
        PoolProperties poolProps = new PoolProperties();
        poolProps.setUrl(config.getUrl());
        poolProps.setDriverClassName(config.getDriver());
        poolProps.setUsername(config.getUser());
        poolProps.setPassword(config.getPass());
        Properties connProps = config.getConnProps();
        if (MapUtil.isNotEmpty(connProps)) {
            poolProps.setDbProperties(connProps);
        }
        Props.of(config.getPoolProps()).toBean(poolProps);
        return new DataSource((PoolConfiguration)poolProps);
    }
}

