/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db.meta;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.dromara.hutool.core.collection.ListUtil;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.db.DbException;
import org.dromara.hutool.db.Entity;
import org.dromara.hutool.db.meta.DatabaseMetaDataWrapper;
import org.dromara.hutool.db.meta.IndexInfo;
import org.dromara.hutool.db.meta.Table;
import org.dromara.hutool.db.meta.TableType;

public class MetaUtil {
    public static List<String> getTableNames(DataSource ds) {
        return MetaUtil.getTableNames(ds, TableType.TABLE);
    }

    public static List<String> getTableNames(DataSource ds, TableType ... types) {
        return MetaUtil.getTableNames(ds, null, null, types);
    }

    public static List<String> getTableNames(DataSource ds, String schema, TableType ... types) {
        return MetaUtil.getTableNames(ds, schema, null, types);
    }

    public static List<String> getTableNames(DataSource ds, String schema, String tableNamePattern, TableType ... types) {
        return MetaUtil.getTableNames(ds, null, schema, tableNamePattern, types);
    }

    public static List<String> getTableNames(DataSource ds, String catalog, String schema, String tableNamePattern, TableType ... types) {
        List<String> list;
        Connection conn = null;
        try {
            conn = ds.getConnection();
            if (null == schema) {
                catalog = MetaUtil.getCatalog(conn);
            }
            if (null == schema) {
                schema = MetaUtil.getSchema(conn);
            }
            list = DatabaseMetaDataWrapper.of(conn.getMetaData(), catalog, schema).getTableNames(tableNamePattern, types);
        }
        catch (Exception e) {
            try {
                throw new DbException("Get tables error!", e);
            }
            catch (Throwable throwable) {
                IoUtil.closeQuietly(conn);
                throw throwable;
            }
        }
        IoUtil.closeQuietly(conn);
        return list;
    }

    public static String[] getColumnNames(ResultSet rs) throws DbException {
        ResultSetMetaData metaData;
        try {
            metaData = rs.getMetaData();
        }
        catch (SQLException e) {
            throw new DbException(e);
        }
        return MetaUtil.getColumnNames(metaData);
    }

    public static String[] getColumnNames(ResultSetMetaData metaData) throws DbException {
        try {
            int columnCount = metaData.getColumnCount();
            String[] labelNames = new String[columnCount];
            for (int i = 0; i < labelNames.length; ++i) {
                labelNames[i] = metaData.getColumnLabel(i + 1);
            }
            return labelNames;
        }
        catch (SQLException e) {
            throw new DbException("Get colunms error!", e);
        }
    }

    public static String[] getColumnNames(DataSource ds, String tableName) {
        String[] stringArray;
        Connection conn = null;
        try {
            conn = ds.getConnection();
            stringArray = DatabaseMetaDataWrapper.of(conn).getColumnNames(tableName);
        }
        catch (Exception e) {
            try {
                throw new DbException("Get columns error!", e);
            }
            catch (Throwable throwable) {
                IoUtil.closeQuietly(conn);
                throw throwable;
            }
        }
        IoUtil.closeQuietly(conn);
        return stringArray;
    }

    public static Entity createLimitedEntity(DataSource ds, String tableName) {
        String[] columnNames = MetaUtil.getColumnNames(ds, tableName);
        return Entity.of(tableName).setFieldNames(columnNames);
    }

    public static Table getTableMeta(DataSource ds, String tableName) {
        return MetaUtil.getTableMeta(ds, null, null, tableName);
    }

    public static Table getTableMeta(DataSource ds, String catalog, String schema, String tableName) {
        Table table;
        Connection conn = null;
        try {
            conn = ds.getConnection();
            table = MetaUtil.getTableMeta(conn, catalog, schema, tableName);
        }
        catch (SQLException e) {
            try {
                throw new DbException(e);
            }
            catch (Throwable throwable) {
                IoUtil.closeQuietly(conn);
                throw throwable;
            }
        }
        IoUtil.closeQuietly(conn);
        return table;
    }

    public static Table getTableMeta(Connection conn, String catalog, String schema, String tableName) {
        Table table = Table.of(tableName);
        if (null == catalog) {
            catalog = MetaUtil.getCatalog(conn);
        }
        table.setCatalog(catalog);
        if (null == schema) {
            schema = MetaUtil.getSchema(conn);
        }
        table.setSchema(schema);
        DatabaseMetaData metaData = MetaUtil.getMetaData(conn);
        DatabaseMetaDataWrapper metaDataWrapper = DatabaseMetaDataWrapper.of(metaData, catalog, schema);
        String pureTableName = metaDataWrapper.getPureTableName(tableName);
        table.setPureTableName(pureTableName);
        table.setRemarks(metaDataWrapper.getRemarks(pureTableName));
        table.setPkNames(metaDataWrapper.getPrimaryKeys(pureTableName));
        metaDataWrapper.fetchColumns(table);
        Map<String, IndexInfo> indexInfoMap = metaDataWrapper.getIndexInfo(tableName);
        table.setIndexInfoList(ListUtil.of(indexInfoMap.values()));
        return table;
    }

    public static String getCatalog(Connection conn) {
        if (null == conn) {
            return null;
        }
        try {
            return conn.getCatalog();
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    public static String getSchema(Connection conn) {
        if (null == conn) {
            return null;
        }
        try {
            return conn.getSchema();
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    public static DatabaseMetaData getMetaData(Connection conn) {
        if (null == conn) {
            return null;
        }
        try {
            return conn.getMetaData();
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    public static String getRemarks(DatabaseMetaData metaData, String catalog, String schema, String tableName) {
        return DatabaseMetaDataWrapper.of(metaData, catalog, schema).getRemarks(tableName);
    }

    public static Set<String> getPrimaryKeys(DatabaseMetaData metaData, String catalog, String schema, String tableName) {
        return DatabaseMetaDataWrapper.of(metaData, catalog, schema).getPrimaryKeys(tableName);
    }

    public static Map<String, IndexInfo> getIndexInfo(DatabaseMetaData metaData, String catalog, String schema, String tableName) {
        return DatabaseMetaDataWrapper.of(metaData, catalog, schema).getIndexInfo(tableName);
    }

    public static boolean isOracle(DatabaseMetaData metaData) throws DbException {
        try {
            return StrUtil.equalsIgnoreCase("Oracle", metaData.getDatabaseProductName());
        }
        catch (SQLException e) {
            throw new DbException(e);
        }
    }
}

