/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.extra.aop.engine.spring;

import java.lang.reflect.Constructor;
import org.dromara.hutool.core.reflect.ClassUtil;
import org.dromara.hutool.core.reflect.ConstructorUtil;
import org.dromara.hutool.extra.aop.Aspect;
import org.dromara.hutool.extra.aop.engine.ProxyEngine;
import org.dromara.hutool.extra.aop.engine.spring.SpringCglibInterceptor;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.Enhancer;

public class SpringCglibProxyEngine
implements ProxyEngine {
    @Override
    public <T> T proxy(T target, Aspect aspect) {
        Class<?> targetClass = target.getClass();
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(targetClass);
        enhancer.setCallback((Callback)new SpringCglibInterceptor(target, aspect));
        return SpringCglibProxyEngine.create(enhancer, targetClass);
    }

    private static <T> T create(Enhancer enhancer, Class<?> targetClass) {
        Constructor<?>[] constructors = ConstructorUtil.getConstructors(targetClass);
        IllegalArgumentException finalException = null;
        for (Constructor<?> constructor : constructors) {
            Class[] parameterTypes = constructor.getParameterTypes();
            Object[] values = ClassUtil.getDefaultValues(parameterTypes);
            try {
                return (T)enhancer.create(parameterTypes, values);
            }
            catch (IllegalArgumentException e) {
                finalException = e;
            }
        }
        if (null != finalException) {
            throw finalException;
        }
        throw new IllegalArgumentException("No constructor provided");
    }
}

