/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.log.engine.jdk;

import java.io.InputStream;
import java.util.logging.LogManager;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.io.resource.ResourceUtil;
import org.dromara.hutool.core.lang.Console;
import org.dromara.hutool.log.AbsLogEngine;
import org.dromara.hutool.log.Log;
import org.dromara.hutool.log.engine.jdk.JdkLog;

public class JdkLogEngine
extends AbsLogEngine {
    public JdkLogEngine() {
        super("JDK Logging");
        this.readConfig();
    }

    @Override
    public Log createLog(String name) {
        return new JdkLog(name);
    }

    @Override
    public Log createLog(Class<?> clazz) {
        return new JdkLog(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readConfig() {
        InputStream in = ResourceUtil.getStreamSafe("logging.properties");
        if (null == in) {
            System.err.println("[WARN] Can not find [logging.properties], use [%JRE_HOME%/lib/logging.properties] as default!");
            return;
        }
        try {
            LogManager.getLogManager().readConfiguration(in);
        }
        catch (Exception e) {
            try {
                Console.error(e, "Read [logging.properties] from classpath error!", new Object[0]);
                try {
                    LogManager.getLogManager().readConfiguration();
                }
                catch (Exception e1) {
                    Console.error(e, "Read [logging.properties] from [%JRE_HOME%/lib/logging.properties] error!", new Object[0]);
                }
            }
            catch (Throwable throwable) {
                IoUtil.closeQuietly(in);
                throw throwable;
            }
            IoUtil.closeQuietly(in);
        }
        IoUtil.closeQuietly(in);
    }
}

