/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.dromara.hutool.core.annotation.AnnotationMapping;
import org.dromara.hutool.core.map.concurrent.SafeConcurrentHashMap;
import org.dromara.hutool.core.reflect.method.MethodUtil;
import org.dromara.hutool.core.text.CharSequenceUtil;

public final class AnnotationMappingProxy<T extends Annotation>
implements InvocationHandler {
    private final AnnotationMapping<T> mapping;
    private final Map<String, BiFunction<Method, Object[], Object>> methods;
    private final Map<String, Object> valueCache;

    public static <A extends Annotation> A create(Class<? extends A> annotationType, AnnotationMapping<A> mapping) {
        Objects.requireNonNull(annotationType);
        Objects.requireNonNull(mapping);
        AnnotationMappingProxy<A> invocationHandler = new AnnotationMappingProxy<A>(mapping);
        return (A)((Annotation)Proxy.newProxyInstance(annotationType.getClassLoader(), new Class[]{annotationType, Proxied.class}, invocationHandler));
    }

    public static boolean isProxied(Annotation annotation) {
        return annotation instanceof Proxied;
    }

    private AnnotationMappingProxy(AnnotationMapping<T> annotation) {
        int methodCount = annotation.getAttributes().length;
        this.methods = new HashMap<String, BiFunction<Method, Object[], Object>>(methodCount + 5);
        this.valueCache = new SafeConcurrentHashMap<String, Object>(methodCount);
        this.mapping = annotation;
        this.loadMethods();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        return Optional.ofNullable(this.methods.get(method.getName())).map(m -> m.apply(method, args)).orElseGet(() -> MethodUtil.invoke((Object)this, method, args));
    }

    private void loadMethods() {
        this.methods.put("equals", (method, args) -> this.proxyEquals(args[0]));
        this.methods.put("toString", (method, args) -> this.proxyToString());
        this.methods.put("hashCode", (method, args) -> this.proxyHashCode());
        this.methods.put("annotationType", (method, args) -> this.proxyAnnotationType());
        this.methods.put("getMapping", (method, args) -> this.proxyGetMapping());
        for (Method attribute : this.mapping.getAttributes()) {
            this.methods.put(attribute.getName(), (method, args) -> this.getAttributeValue(method.getName(), method.getReturnType()));
        }
    }

    private String proxyToString() {
        String attributes = Stream.of(this.mapping.getAttributes()).map(attribute -> CharSequenceUtil.format("{}={}", attribute.getName(), this.getAttributeValue(attribute.getName(), attribute.getReturnType()))).collect(Collectors.joining(", "));
        return CharSequenceUtil.format("@{}({})", this.mapping.annotationType().getName(), attributes);
    }

    private int proxyHashCode() {
        return this.hashCode();
    }

    private boolean proxyEquals(Object o) {
        return Objects.equals(this.mapping, o);
    }

    private Class<? extends Annotation> proxyAnnotationType() {
        return this.mapping.annotationType();
    }

    private AnnotationMapping<T> proxyGetMapping() {
        return this.mapping;
    }

    private Object getAttributeValue(String attributeName, Class<?> attributeType) {
        return this.valueCache.computeIfAbsent(attributeName, name -> this.mapping.getResolvedAttributeValue(attributeName, attributeType));
    }

    static interface Proxied {
        public AnnotationMapping<Annotation> getMapping();
    }
}

