/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.classloader;

import java.io.File;
import org.dromara.hutool.core.classloader.JarClassLoader;
import org.dromara.hutool.core.exception.HutoolException;
import org.dromara.hutool.core.lang.caller.CallerUtil;
import org.dromara.hutool.core.reflect.ClassDescUtil;

public class ClassLoaderUtil {
    public static ClassLoader getClassLoader() {
        ClassLoader classLoader = CallerUtil.getCallerCaller().getClassLoader();
        if (null == classLoader) {
            classLoader = ClassLoaderUtil.getContextClassLoader();
        }
        if (classLoader == null && null == (classLoader = ClassLoaderUtil.class.getClassLoader())) {
            classLoader = ClassLoaderUtil.getSystemClassLoader();
        }
        return classLoader;
    }

    public static ClassLoader getCallerClassLoader() {
        return CallerUtil.getCallerCaller().getClassLoader();
    }

    public static ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static ClassLoader getSystemClassLoader() {
        return ClassLoader.getSystemClassLoader();
    }

    public static JarClassLoader getJarClassLoader(File jarOrDir) {
        return JarClassLoader.load(jarOrDir);
    }

    public static <T> Class<T> loadClass(String name) throws HutoolException {
        return ClassLoaderUtil.loadClass(name, true);
    }

    public static <T> Class<T> loadClass(String name, boolean isInitialized) throws HutoolException {
        return ClassLoaderUtil.loadClass(name, isInitialized, null);
    }

    public static <T> Class<T> loadClass(String name, boolean isInitialized, ClassLoader classLoader) throws HutoolException {
        return ClassDescUtil.nameToClass(name, isInitialized, classLoader);
    }

    public static Class<?> loadClass(File jarOrDir, String name) {
        try {
            return ClassLoaderUtil.getJarClassLoader(jarOrDir).loadClass(name);
        }
        catch (ClassNotFoundException e) {
            throw new HutoolException(e);
        }
    }

    public static boolean isPresent(String className) {
        return ClassLoaderUtil.isPresent(className, null);
    }

    public static boolean isPresent(String className, ClassLoader classLoader) {
        try {
            ClassLoaderUtil.loadClass(className, false, classLoader);
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }
}

