/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.codec.hash;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.dromara.hutool.core.codec.hash.Hash32;
import org.dromara.hutool.core.codec.hash.Hash64;
import org.dromara.hutool.core.exception.HutoolException;

public class KetamaHash
implements Hash64<byte[]>,
Hash32<byte[]> {
    @Override
    public long hash64(byte[] key) {
        byte[] bKey = KetamaHash.md5(key);
        return (long)(bKey[3] & 0xFF) << 24 | (long)(bKey[2] & 0xFF) << 16 | (long)(bKey[1] & 0xFF) << 8 | (long)(bKey[0] & 0xFF);
    }

    @Override
    public int hash32(byte[] key) {
        return (int)(this.hash64(key) & 0xFFFFFFFFL);
    }

    @Override
    public Number encode(byte[] key) {
        return this.hash64(key);
    }

    private static byte[] md5(byte[] key) {
        MessageDigest md5;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new HutoolException("MD5 algorithm not suooport!", e);
        }
        return md5.digest(key);
    }
}

