/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.collection.set;

import java.util.Collection;
import org.dromara.hutool.core.collection.set.SetFromMap;
import org.dromara.hutool.core.map.concurrent.ConcurrentLinkedHashMap;

public class ConcurrentLinkedHashSet<E>
extends SetFromMap<E> {
    private static final long serialVersionUID = 7997886765361607470L;

    public ConcurrentLinkedHashSet() {
        super(new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(64L).build());
    }

    public ConcurrentLinkedHashSet(int initialCapacity) {
        super(new ConcurrentLinkedHashMap.Builder().initialCapacity(initialCapacity).maximumWeightedCapacity(initialCapacity).build());
    }

    public ConcurrentLinkedHashSet(int initialCapacity, int concurrencyLevel) {
        super(new ConcurrentLinkedHashMap.Builder().initialCapacity(initialCapacity).maximumWeightedCapacity(initialCapacity).concurrencyLevel(concurrencyLevel).build());
    }

    public ConcurrentLinkedHashSet(Iterable<E> iter) {
        super(iter instanceof Collection ? new ConcurrentLinkedHashMap.Builder().initialCapacity(((Collection)iter).size()).build() : new ConcurrentLinkedHashMap.Builder().build());
        if (iter instanceof Collection) {
            this.addAll((Collection)iter);
        } else {
            for (E e : iter) {
                this.add(e);
            }
        }
    }
}

