/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.convert;

import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Currency;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.datatype.XMLGregorianCalendar;
import org.dromara.hutool.core.collection.set.ConcurrentHashSet;
import org.dromara.hutool.core.convert.ConvertException;
import org.dromara.hutool.core.convert.Converter;
import org.dromara.hutool.core.convert.ConverterWithRoot;
import org.dromara.hutool.core.convert.MatcherConverter;
import org.dromara.hutool.core.convert.impl.AtomicBooleanConverter;
import org.dromara.hutool.core.convert.impl.AtomicIntegerArrayConverter;
import org.dromara.hutool.core.convert.impl.AtomicLongArrayConverter;
import org.dromara.hutool.core.convert.impl.AtomicReferenceConverter;
import org.dromara.hutool.core.convert.impl.BooleanConverter;
import org.dromara.hutool.core.convert.impl.CalendarConverter;
import org.dromara.hutool.core.convert.impl.CharacterConverter;
import org.dromara.hutool.core.convert.impl.CharsetConverter;
import org.dromara.hutool.core.convert.impl.CurrencyConverter;
import org.dromara.hutool.core.convert.impl.DurationConverter;
import org.dromara.hutool.core.convert.impl.LocaleConverter;
import org.dromara.hutool.core.convert.impl.OptConverter;
import org.dromara.hutool.core.convert.impl.OptionalConverter;
import org.dromara.hutool.core.convert.impl.PairConverter;
import org.dromara.hutool.core.convert.impl.PathConverter;
import org.dromara.hutool.core.convert.impl.PeriodConverter;
import org.dromara.hutool.core.convert.impl.ReferenceConverter;
import org.dromara.hutool.core.convert.impl.StackTraceElementConverter;
import org.dromara.hutool.core.convert.impl.StringConverter;
import org.dromara.hutool.core.convert.impl.TemporalAccessorConverter;
import org.dromara.hutool.core.convert.impl.TripleConverter;
import org.dromara.hutool.core.convert.impl.TupleConverter;
import org.dromara.hutool.core.convert.impl.URIConverter;
import org.dromara.hutool.core.convert.impl.URLConverter;
import org.dromara.hutool.core.convert.impl.UUIDConverter;
import org.dromara.hutool.core.convert.impl.XMLGregorianCalendarConverter;
import org.dromara.hutool.core.lang.Opt;
import org.dromara.hutool.core.lang.tuple.Pair;
import org.dromara.hutool.core.lang.tuple.Triple;
import org.dromara.hutool.core.lang.tuple.Tuple;
import org.dromara.hutool.core.map.concurrent.SafeConcurrentHashMap;
import org.dromara.hutool.core.reflect.TypeUtil;
import org.dromara.hutool.core.stream.StreamUtil;

public class RegisterConverter
extends ConverterWithRoot
implements Serializable {
    private static final long serialVersionUID = 1L;
    private volatile Set<MatcherConverter> converterSet;
    private volatile Map<Type, Converter> customConverterMap;
    private final Map<Class<?>, Converter> defaultConverterMap;

    public RegisterConverter(Converter rootConverter) {
        super(rootConverter);
        this.defaultConverterMap = RegisterConverter.initDefault(rootConverter);
    }

    @Override
    public Object convert(Type targetType, Object value) throws ConvertException {
        Converter converter = this.getConverter(targetType, value, true);
        if (null != converter) {
            return converter.convert(targetType, value);
        }
        throw new ConvertException("Can not support from {}: [{}] to [{}]", value.getClass().getName(), value, targetType.getTypeName());
    }

    public Converter getConverter(Type type, Object value, boolean isCustomFirst) {
        Converter converter;
        if (isCustomFirst) {
            converter = this.getCustomConverter(type, value);
            if (null == converter) {
                converter = this.getCustomConverter(type);
            }
            if (null == converter) {
                converter = this.getDefaultConverter(type);
            }
        } else {
            converter = this.getDefaultConverter(type);
            if (null == converter) {
                converter = this.getCustomConverter(type, value);
            }
            if (null == converter) {
                converter = this.getCustomConverter(type);
            }
        }
        return converter;
    }

    public Converter getDefaultConverter(Type type) {
        Class<?> key = null == type ? null : TypeUtil.getClass(type);
        return null == this.defaultConverterMap || null == key ? null : this.defaultConverterMap.get(key);
    }

    public Converter getCustomConverter(Type type, Object value) {
        return StreamUtil.of(this.converterSet).filter(predicate -> predicate.match(type, value)).findFirst().orElse(null);
    }

    public Converter getCustomConverter(Type type) {
        return null == this.customConverterMap ? null : this.customConverterMap.get(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegisterConverter register(Type type, Converter converter) {
        if (null == this.customConverterMap) {
            RegisterConverter registerConverter = this;
            synchronized (registerConverter) {
                if (null == this.customConverterMap) {
                    this.customConverterMap = new SafeConcurrentHashMap<Type, Converter>();
                }
            }
        }
        this.customConverterMap.put(type, converter);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegisterConverter register(MatcherConverter converter) {
        if (null == this.converterSet) {
            RegisterConverter registerConverter = this;
            synchronized (registerConverter) {
                if (null == this.converterSet) {
                    this.converterSet = new ConcurrentHashSet<MatcherConverter>();
                }
            }
        }
        this.converterSet.add(converter);
        return this;
    }

    private static Map<Class<?>, Converter> initDefault(Converter rootConverter) {
        SafeConcurrentHashMap converterMap = new SafeConcurrentHashMap(64);
        converterMap.put(Character.class, CharacterConverter.INSTANCE);
        converterMap.put(Boolean.class, BooleanConverter.INSTANCE);
        converterMap.put(AtomicBoolean.class, AtomicBooleanConverter.INSTANCE);
        StringConverter stringConverter = new StringConverter();
        converterMap.put(CharSequence.class, stringConverter);
        converterMap.put(String.class, stringConverter);
        converterMap.put(URI.class, new URIConverter());
        converterMap.put(URL.class, new URLConverter());
        converterMap.put(Calendar.class, new CalendarConverter());
        try {
            converterMap.put(XMLGregorianCalendar.class, new XMLGregorianCalendarConverter());
        }
        catch (Exception exception) {
            // empty catch block
        }
        converterMap.put(TemporalAccessor.class, TemporalAccessorConverter.INSTANCE);
        converterMap.put(Instant.class, TemporalAccessorConverter.INSTANCE);
        converterMap.put(LocalDateTime.class, TemporalAccessorConverter.INSTANCE);
        converterMap.put(LocalDate.class, TemporalAccessorConverter.INSTANCE);
        converterMap.put(LocalTime.class, TemporalAccessorConverter.INSTANCE);
        converterMap.put(ZonedDateTime.class, TemporalAccessorConverter.INSTANCE);
        converterMap.put(OffsetDateTime.class, TemporalAccessorConverter.INSTANCE);
        converterMap.put(OffsetTime.class, TemporalAccessorConverter.INSTANCE);
        converterMap.put(DayOfWeek.class, TemporalAccessorConverter.INSTANCE);
        converterMap.put(Month.class, TemporalAccessorConverter.INSTANCE);
        converterMap.put(MonthDay.class, TemporalAccessorConverter.INSTANCE);
        converterMap.put(Period.class, new PeriodConverter());
        converterMap.put(Duration.class, new DurationConverter());
        ReferenceConverter referenceConverter = new ReferenceConverter(rootConverter);
        converterMap.put(WeakReference.class, referenceConverter);
        converterMap.put(SoftReference.class, referenceConverter);
        converterMap.put(AtomicReference.class, new AtomicReferenceConverter(rootConverter));
        converterMap.put(AtomicIntegerArray.class, new AtomicIntegerArrayConverter());
        converterMap.put(AtomicLongArray.class, new AtomicLongArrayConverter());
        converterMap.put(Locale.class, new LocaleConverter());
        converterMap.put(Charset.class, new CharsetConverter());
        converterMap.put(Path.class, new PathConverter());
        converterMap.put(Currency.class, new CurrencyConverter());
        converterMap.put(UUID.class, new UUIDConverter());
        converterMap.put(StackTraceElement.class, new StackTraceElementConverter());
        converterMap.put(Optional.class, new OptionalConverter());
        converterMap.put(Opt.class, new OptConverter());
        converterMap.put(Pair.class, new PairConverter(rootConverter));
        converterMap.put(Triple.class, new TripleConverter(rootConverter));
        converterMap.put(Tuple.class, TupleConverter.INSTANCE);
        return converterMap;
    }
}

