/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.data;

import org.dromara.hutool.core.data.masking.MaskingManager;
import org.dromara.hutool.core.data.masking.MaskingType;
import org.dromara.hutool.core.text.StrUtil;

public class MaskingUtil {
    public static String masking(MaskingType maskingType, CharSequence str) {
        return MaskingManager.getInstance().masking(maskingType.name(), str);
    }

    public static String clear() {
        return "";
    }

    public static String clearToNull() {
        return null;
    }

    public static Long userId() {
        return 0L;
    }

    public static String chineseName(CharSequence fullName) {
        return MaskingUtil.firstMask(fullName);
    }

    public static String firstMask(CharSequence str) {
        return MaskingManager.EMPTY.firstMask(str);
    }

    public static String idCardNum(CharSequence idCardNum, int front, int end) {
        return MaskingManager.EMPTY.idCardNum(idCardNum, front, end);
    }

    public static String fixedPhone(CharSequence num) {
        return MaskingManager.EMPTY.fixedPhone(num);
    }

    public static String mobilePhone(CharSequence num) {
        return MaskingManager.EMPTY.mobilePhone(num);
    }

    public static String address(CharSequence address, int sensitiveSize) {
        return MaskingManager.EMPTY.address(address, sensitiveSize);
    }

    public static String email(CharSequence email) {
        return MaskingManager.EMPTY.email(email);
    }

    public static String password(CharSequence password) {
        if (StrUtil.isBlank(password)) {
            return "";
        }
        return StrUtil.repeat('*', 10);
    }

    public static String carLicense(CharSequence carLicense) {
        return MaskingManager.EMPTY.carLicense(carLicense);
    }

    public static String bankCard(CharSequence bankCardNo) {
        return MaskingManager.EMPTY.bankCard(bankCardNo);
    }

    public static String ipv4(CharSequence ipv4) {
        return MaskingManager.EMPTY.ipv4(ipv4);
    }

    public static String ipv6(CharSequence ipv6) {
        return MaskingManager.EMPTY.ipv6(ipv6);
    }
}

