/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.io.resource;

import java.nio.charset.Charset;
import org.dromara.hutool.core.io.resource.BytesResource;
import org.dromara.hutool.core.util.ByteUtil;
import org.dromara.hutool.core.util.CharsetUtil;

public class CharSequenceResource
extends BytesResource {
    private static final long serialVersionUID = 1L;
    private final String charsetName;

    public CharSequenceResource(CharSequence data) {
        this(data, null);
    }

    public CharSequenceResource(CharSequence data, String name) {
        this(data, name, CharsetUtil.UTF_8);
    }

    public CharSequenceResource(CharSequence data, String name, Charset charset) {
        super(ByteUtil.toBytes(data, charset), name);
        this.charsetName = charset.name();
    }

    public String readStr() {
        return this.readStr(this.getCharset());
    }

    public String getCharsetName() {
        return this.charsetName;
    }

    public Charset getCharset() {
        return CharsetUtil.charset(this.charsetName);
    }
}

