/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.io.resource;

import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.jar.JarFile;
import org.dromara.hutool.core.compress.ZipUtil;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.io.resource.UrlResource;

public class JarResource
extends UrlResource {
    private static final long serialVersionUID = 1L;

    public JarResource(URI uri) {
        super(uri);
    }

    public JarResource(URL url) {
        super(url);
    }

    public JarResource(URL url, String name) {
        super(url, name);
    }

    public JarFile getJarFile() throws IORuntimeException {
        try {
            return this.doGetJarFile();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    private JarFile doGetJarFile() throws IOException {
        URLConnection con = this.getUrl().openConnection();
        if (con instanceof JarURLConnection) {
            JarURLConnection jarCon = (JarURLConnection)con;
            return jarCon.getJarFile();
        }
        String urlFile = this.getUrl().getFile();
        int separatorIndex = urlFile.indexOf("*/");
        if (separatorIndex == -1) {
            separatorIndex = urlFile.indexOf("!/");
        }
        if (separatorIndex != -1) {
            return ZipUtil.ofJar(urlFile.substring(0, separatorIndex));
        }
        return new JarFile(urlFile);
    }
}

