/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.map.multi;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.dromara.hutool.core.exception.HutoolException;

public class DirectedWeightGraph<T> {
    private final Set<T> allPoints = new HashSet<T>();
    private final Map<T, Map<T, Edge<T>>> neighborEdgeMap = new HashMap<T, Map<T, Edge<T>>>();

    public Set<T> getAllPoints() {
        return this.allPoints;
    }

    public void putEdge(T fromPoint, T nextPoint, long weight) {
        this.allPoints.add(fromPoint);
        this.allPoints.add(nextPoint);
        Map nextPointMap = this.neighborEdgeMap.computeIfAbsent(fromPoint, k -> new HashMap());
        nextPointMap.put(nextPoint, new Edge<T>(fromPoint, nextPoint, weight));
    }

    public void removeEdge(T fromPoint, T nextPoint) {
        Map nextPointMap = this.neighborEdgeMap.computeIfAbsent(fromPoint, k -> new HashMap());
        nextPointMap.remove(nextPoint);
        this.allPoints.clear();
        this.neighborEdgeMap.forEach((f, m) -> {
            this.allPoints.add(f);
            m.forEach((t, e) -> this.allPoints.add(t));
        });
    }

    public void removePoint(T point) {
        this.allPoints.remove(point);
        this.neighborEdgeMap.remove(point);
        this.neighborEdgeMap.forEach((f, m) -> m.remove(point));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.neighborEdgeMap.forEach((from, edgeMap) -> edgeMap.forEach((to, edge) -> {
            builder.append(edge);
            builder.append("\r\n");
        }));
        return builder.toString();
    }

    public Map<T, Path<T>> bestPathMap(T startPoint) throws NegativeRingException {
        LinkedList pointQueue = new LinkedList();
        HashSet inQueuePoints = new HashSet();
        HashMap bestPathMap = new HashMap();
        Map<T, Edge<T>> map = this.neighborEdgeMap.get(startPoint);
        if (map == null || map.isEmpty()) {
            return new HashMap();
        }
        map.forEach((to, edge) -> {
            Path path = new Path(edge);
            bestPathMap.put(to, path);
            pointQueue.add(to);
            inQueuePoints.add(to);
        });
        while (!pointQueue.isEmpty()) {
            Object currentPoint = pointQueue.removeFirst();
            Path currentPath = (Path)bestPathMap.get(currentPoint);
            inQueuePoints.remove(currentPoint);
            Map<T, Edge<T>> edgeMap = this.neighborEdgeMap.get(currentPoint);
            if (edgeMap == null) continue;
            Set<Map.Entry<T, Edge<T>>> entrySet = edgeMap.entrySet();
            for (Map.Entry<T, Edge<T>> entry : entrySet) {
                T nextPoint = entry.getKey();
                Edge<T> edge2 = entry.getValue();
                Path oldPath = (Path)bestPathMap.get(nextPoint);
                if (oldPath == null) {
                    Path<T> nextPath = currentPath.nextPoint(edge2);
                    bestPathMap.put(nextPoint, nextPath);
                    if (inQueuePoints.contains(nextPoint)) continue;
                    inQueuePoints.add(nextPoint);
                    if (pointQueue.isEmpty()) {
                        pointQueue.addLast(nextPoint);
                        continue;
                    }
                    Object first = pointQueue.getFirst();
                    Path fristPath = (Path)bestPathMap.get(first);
                    if (nextPath.weight < fristPath.weight) {
                        pointQueue.addFirst(nextPoint);
                        continue;
                    }
                    pointQueue.add(nextPoint);
                    continue;
                }
                long newWeight = currentPath.weight + edge2.weight;
                if (newWeight >= oldPath.weight) continue;
                Path<T> nextPath = currentPath.nextPoint(edge2);
                bestPathMap.put(nextPoint, nextPath);
                if (inQueuePoints.contains(nextPoint)) continue;
                inQueuePoints.add(nextPoint);
                if (pointQueue.isEmpty()) {
                    pointQueue.addLast(nextPoint);
                    continue;
                }
                Object first = pointQueue.getFirst();
                Path fristPath = (Path)bestPathMap.get(first);
                if (nextPath.weight < fristPath.weight) {
                    pointQueue.addFirst(nextPoint);
                    continue;
                }
                pointQueue.addLast(nextPoint);
            }
        }
        return bestPathMap;
    }

    public static class NegativeRingException
    extends HutoolException {
        private static final long serialVersionUID = 1L;

        public NegativeRingException(String msg) {
            super(msg);
        }
    }

    public static class Path<T>
    extends Edge<T> {
        private final LinkedList<Edge<T>> way = new LinkedList();
        private final Set<T> passedPoints = new HashSet<T>();

        public Path() {
        }

        public Path(Edge<T> edge) {
            this.fromPoint = edge.fromPoint;
            this.toPoint = edge.toPoint;
            this.way.add(edge);
            this.weight = edge.weight;
            this.passedPoints.add(edge.fromPoint);
            this.passedPoints.add(edge.toPoint);
        }

        public Path<T> nextPoint(Edge<T> edge) throws NegativeRingException {
            Path<T> nextPath = new Path<T>();
            nextPath.fromPoint = this.fromPoint;
            nextPath.toPoint = edge.toPoint;
            nextPath.way.addAll(this.way);
            nextPath.way.add(edge);
            nextPath.weight = this.weight + edge.weight;
            nextPath.passedPoints.addAll(this.passedPoints);
            if (nextPath.passedPoints.contains(edge.toPoint)) {
                throw new NegativeRingException("\u8def\u5f84:" + nextPath + "\u5b58\u5728\u8d1f\u73af\u8def");
            }
            nextPath.passedPoints.add(edge.toPoint);
            return nextPath;
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(String.format("[%s->%s(%d)]  ", this.fromPoint, this.toPoint, this.weight));
            for (Edge edge : this.way) {
                builder.append(edge);
                builder.append(" ");
            }
            return builder.toString();
        }
    }

    public static class Edge<T> {
        protected T fromPoint;
        protected T toPoint;
        protected long weight;

        public Edge() {
        }

        public Edge(T fromPoint, T toPoint, long weight) {
            this.fromPoint = fromPoint;
            this.toPoint = toPoint;
            this.weight = weight;
        }

        public String toString() {
            return this.fromPoint + "->" + this.toPoint + "(" + this.weight + ")";
        }
    }
}

