/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.reflect;

import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.bean.NullWrapperBean;
import org.dromara.hutool.core.classloader.ClassLoaderUtil;
import org.dromara.hutool.core.convert.BasicType;
import org.dromara.hutool.core.exception.HutoolException;
import org.dromara.hutool.core.func.PredicateUtil;
import org.dromara.hutool.core.io.file.FileUtil;
import org.dromara.hutool.core.io.resource.ResourceUtil;
import org.dromara.hutool.core.net.url.UrlDecoder;
import org.dromara.hutool.core.net.url.UrlUtil;
import org.dromara.hutool.core.reflect.ClassScanner;
import org.dromara.hutool.core.reflect.ModifierUtil;
import org.dromara.hutool.core.reflect.TypeUtil;
import org.dromara.hutool.core.stream.EasyStream;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.text.split.SplitUtil;
import org.dromara.hutool.core.util.CharsetUtil;

public class ClassUtil {
    private static final char PACKAGE_SEPARATOR = '.';
    private static final char INNER_CLASS_SEPARATOR = '$';

    public static <T> Class<T> getClass(T obj) {
        return null == obj ? null : obj.getClass();
    }

    public static Class<?> getEnclosingClass(Class<?> clazz) {
        return null == clazz ? null : clazz.getEnclosingClass();
    }

    public static boolean isTopLevelClass(Class<?> clazz) {
        if (null == clazz) {
            return false;
        }
        return null == ClassUtil.getEnclosingClass(clazz);
    }

    public static String getClassName(Object obj, boolean isSimple) {
        if (null == obj) {
            return null;
        }
        Class<?> clazz = obj.getClass();
        return ClassUtil.getClassName(clazz, isSimple);
    }

    public static String getClassName(Class<?> clazz, boolean isSimple) {
        if (null == clazz) {
            return null;
        }
        return isSimple ? clazz.getSimpleName() : clazz.getName();
    }

    public static String getShortClassName(String className) {
        List<String> packages = SplitUtil.split(className, ".");
        if (null == packages || packages.size() < 2) {
            return className;
        }
        int size = packages.size();
        StringBuilder result = StrUtil.builder();
        result.append(packages.get(0).charAt(0));
        for (int i = 1; i < size - 1; ++i) {
            result.append('.').append(packages.get(i).charAt(0));
        }
        result.append('.').append(packages.get(size - 1));
        return result.toString();
    }

    public static Class<?>[] getClasses(Object ... objects) {
        Class[] classes = new Class[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            Object obj = objects[i];
            classes[i] = obj instanceof NullWrapperBean ? ((NullWrapperBean)obj).getWrappedClass() : (null == obj ? Object.class : obj.getClass());
        }
        return classes;
    }

    public static boolean equals(Class<?> clazz, String className, boolean ignoreCase) {
        if (null == clazz || StrUtil.isBlank(className)) {
            return false;
        }
        if (ignoreCase) {
            return className.equalsIgnoreCase(clazz.getName()) || className.equalsIgnoreCase(clazz.getSimpleName());
        }
        return className.equals(clazz.getName()) || className.equals(clazz.getSimpleName());
    }

    public static Set<Class<?>> scanPackageByAnnotation(String packageName, Class<? extends Annotation> annotationClass) {
        return ClassScanner.scanPackageByAnnotation(packageName, annotationClass);
    }

    public static Set<Class<?>> scanPackageBySuper(String packageName, Class<?> superClass) {
        return ClassScanner.scanPackageBySuper(packageName, superClass);
    }

    public static Set<Class<?>> scanPackage() {
        return ClassScanner.scanPackage();
    }

    public static Set<Class<?>> scanPackage(String packageName) {
        return ClassScanner.scanPackage(packageName);
    }

    public static Set<Class<?>> scanPackage(String packageName, Predicate<Class<?>> classFilter) {
        return ClassScanner.scanPackage(packageName, classFilter);
    }

    public static Set<String> getClassPathResources() {
        return ClassUtil.getClassPathResources(false);
    }

    public static Set<String> getClassPathResources(boolean isDecode) {
        return ClassUtil.getClassPaths("", isDecode);
    }

    public static Set<String> getClassPaths(String packageName) {
        return ClassUtil.getClassPaths(packageName, false);
    }

    public static Set<String> getClassPaths(String packageName, boolean isDecode) {
        Enumeration<URL> resources;
        String packagePath = packageName.replace(".", "/");
        try {
            resources = ClassLoaderUtil.getClassLoader().getResources(packagePath);
        }
        catch (IOException e) {
            throw new HutoolException(e, "Loading classPath [{}] error!", packagePath);
        }
        HashSet<String> paths = new HashSet<String>();
        while (resources.hasMoreElements()) {
            String path = resources.nextElement().getPath();
            paths.add(isDecode ? UrlDecoder.decode(path, CharsetUtil.defaultCharset()) : path);
        }
        return paths;
    }

    public static String getClassPath() {
        return ClassUtil.getClassPath(false);
    }

    public static String getClassPath(boolean isEncoded) {
        URL classPathUrl = ResourceUtil.getResourceUrl("");
        String url = isEncoded ? classPathUrl.getPath() : UrlUtil.getDecodedPath(classPathUrl);
        return FileUtil.normalize(url);
    }

    public static boolean isAllAssignableFrom(Class<?>[] types1, Class<?>[] types2) {
        if (ArrayUtil.isEmpty(types1) && ArrayUtil.isEmpty(types2)) {
            return true;
        }
        if (null == types1 || null == types2) {
            return false;
        }
        if (types1.length != types2.length) {
            return false;
        }
        for (int i = 0; i < types1.length; ++i) {
            Class<?> type1 = types1[i];
            Class<?> type2 = types2[i];
            if (!(ClassUtil.isBasicType(type1) && ClassUtil.isBasicType(type2) ? BasicType.unWrap(type1) != BasicType.unWrap(type2) : !type1.isAssignableFrom(type2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isPrimitiveWrapper(Class<?> clazz) {
        return BasicType.isPrimitiveWrapper(clazz);
    }

    public static boolean isBasicType(Class<?> clazz) {
        if (null == clazz) {
            return false;
        }
        return clazz.isPrimitive() || ClassUtil.isPrimitiveWrapper(clazz);
    }

    public static boolean isSimpleTypeOrArray(Class<?> clazz) {
        if (null == clazz) {
            return false;
        }
        return ClassUtil.isSimpleValueType(clazz) || clazz.isArray() && ClassUtil.isSimpleValueType(clazz.getComponentType());
    }

    public static boolean isSimpleValueType(Class<?> clazz) {
        return ClassUtil.isBasicType(clazz) || clazz.isEnum() || CharSequence.class.isAssignableFrom(clazz) || Number.class.isAssignableFrom(clazz) || Date.class.isAssignableFrom(clazz) || clazz.equals(URI.class) || clazz.equals(URL.class) || clazz.equals(Locale.class) || clazz.equals(Class.class) || TemporalAccessor.class.isAssignableFrom(clazz);
    }

    public static boolean isAssignable(Class<?> targetType, Class<?> sourceType) {
        if (null == targetType || null == sourceType) {
            return false;
        }
        if (targetType.isAssignableFrom(sourceType)) {
            return true;
        }
        if (targetType.isPrimitive()) {
            return targetType.equals(BasicType.unWrap(sourceType));
        }
        Class<?> resolvedWrapper = BasicType.wrap(sourceType, true);
        return resolvedWrapper != null && targetType.isAssignableFrom(resolvedWrapper);
    }

    public static boolean isSerializable(Class<?> clazz) {
        return Serializable.class.isAssignableFrom(clazz);
    }

    public static boolean isNormalClass(Class<?> clazz) {
        return null != clazz && !clazz.isInterface() && !ModifierUtil.isAbstract(clazz) && !clazz.isEnum() && !clazz.isArray() && !clazz.isAnnotation() && !clazz.isSynthetic() && !clazz.isPrimitive();
    }

    public static boolean isEnum(Class<?> clazz) {
        return null != clazz && clazz.isEnum();
    }

    public static Class<?> getTypeArgument(Class<?> clazz) {
        return ClassUtil.getTypeArgument(clazz, 0);
    }

    public static Class<?> getTypeArgument(Class<?> clazz, int index) {
        Type argumentType = TypeUtil.getTypeArgument(clazz, index);
        return TypeUtil.getClass(argumentType);
    }

    public static String getPackage(Class<?> clazz) {
        if (clazz == null) {
            return "";
        }
        String className = clazz.getName();
        int packageEndIndex = className.lastIndexOf(".");
        if (packageEndIndex == -1) {
            return "";
        }
        return className.substring(0, packageEndIndex);
    }

    public static String getPackagePath(Class<?> clazz) {
        return ClassUtil.getPackage(clazz).replace('.', '/');
    }

    public static Object getDefaultValue(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return ClassUtil.getPrimitiveDefaultValue(clazz);
        }
        return null;
    }

    public static Object getPrimitiveDefaultValue(Class<?> clazz) {
        if (Long.TYPE == clazz) {
            return 0L;
        }
        if (Integer.TYPE == clazz) {
            return 0;
        }
        if (Short.TYPE == clazz) {
            return (short)0;
        }
        if (Character.TYPE == clazz) {
            return Character.valueOf('\u0000');
        }
        if (Byte.TYPE == clazz) {
            return (byte)0;
        }
        if (Double.TYPE == clazz) {
            return 0.0;
        }
        if (Float.TYPE == clazz) {
            return Float.valueOf(0.0f);
        }
        if (Boolean.TYPE == clazz) {
            return false;
        }
        return null;
    }

    public static Object[] getDefaultValues(Class<?> ... classes) {
        Object[] values = new Object[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            values[i] = ClassUtil.getDefaultValue(classes[i]);
        }
        return values;
    }

    public static boolean isJdkClass(Class<?> clazz) {
        Package objectPackage = clazz.getPackage();
        if (null == objectPackage) {
            return false;
        }
        String objectPackageName = objectPackage.getName();
        return objectPackageName.startsWith("java.") || objectPackageName.startsWith("javax.") || clazz.getClassLoader() == null;
    }

    public static URL getLocation(Class<?> clazz) {
        if (null == clazz) {
            return null;
        }
        return clazz.getProtectionDomain().getCodeSource().getLocation();
    }

    public static String getLocationPath(Class<?> clazz) {
        URL location = ClassUtil.getLocation(clazz);
        if (null == location) {
            return null;
        }
        return location.getPath();
    }

    public static boolean isClassExists(String className, ClassLoader loader) {
        try {
            return null != ClassUtil.forName(className, false, loader);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Class<?> forName(String name, boolean isInitialized, ClassLoader loader) {
        if (null == loader) {
            loader = ClassLoaderUtil.getClassLoader();
        }
        name = name.replace('/', '.');
        try {
            return Class.forName(name, isInitialized, loader);
        }
        catch (ClassNotFoundException ex) {
            Class<?> clazz = ClassUtil.forNameInnerClass(name, isInitialized, loader);
            if (null == clazz) {
                throw new HutoolException(ex);
            }
            return clazz;
        }
    }

    public static List<Class<?>> getSuperClasses(Class<?> clazz) {
        if (clazz == null) {
            return Collections.emptyList();
        }
        ArrayList superclasses = new ArrayList();
        ClassUtil.traverseTypeHierarchy(clazz, t -> !t.isInterface(), superclasses::add, false);
        return superclasses;
    }

    public static List<Class<?>> getInterfaces(Class<?> cls) {
        if (cls == null) {
            return Collections.emptyList();
        }
        ArrayList interfaces = new ArrayList();
        ClassUtil.traverseTypeHierarchy(cls, t -> true, t -> {
            if (t.isInterface()) {
                interfaces.add((Class<?>)t);
            }
        }, false);
        return interfaces;
    }

    public static void traverseTypeHierarchyWhile(Class<?> root, Predicate<Class<?>> terminator) {
        ClassUtil.traverseTypeHierarchyWhile(root, PredicateUtil.alwaysTrue(), terminator);
    }

    public static void traverseTypeHierarchyWhile(Class<?> root, Predicate<Class<?>> filter, Predicate<Class<?>> terminator) {
        ((EasyStream)EasyStream.iterateHierarchies(root, ClassUtil::getNextTypeHierarchies, filter).takeWhile(terminator)).exec();
    }

    public static void traverseTypeHierarchy(Class<?> root, Predicate<Class<?>> filter, Consumer<Class<?>> consumer, boolean includeRoot) {
        Objects.requireNonNull(root);
        Objects.requireNonNull(filter);
        Objects.requireNonNull(consumer);
        Function<Class, Collection> function = t -> {
            if (includeRoot || !root.equals(t)) {
                consumer.accept((Class<?>)t);
            }
            return ClassUtil.getNextTypeHierarchies(t);
        };
        EasyStream.iterateHierarchies(root, function, filter).exec();
    }

    private static Class<?> forNameInnerClass(String name, boolean isInitialized, ClassLoader classLoader) {
        int lastDotIndex = name.lastIndexOf(46);
        Class<?> clazz = null;
        while (lastDotIndex > 0 && Character.isUpperCase(name.charAt(lastDotIndex + 1))) {
            name = name.substring(0, lastDotIndex) + '$' + name.substring(lastDotIndex + 1);
            try {
                clazz = Class.forName(name, isInitialized, classLoader);
                break;
            }
            catch (ClassNotFoundException classNotFoundException) {
                lastDotIndex = name.lastIndexOf(46);
            }
        }
        return clazz;
    }

    private static Set<Class<?>> getNextTypeHierarchies(Class<?> clazz) {
        LinkedHashSet next = new LinkedHashSet();
        Class<?> superclass = clazz.getSuperclass();
        if (Objects.nonNull(superclass)) {
            next.add(superclass);
        }
        next.addAll(Arrays.asList(clazz.getInterfaces()));
        return next;
    }
}

