/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.convert.Converter;
import org.dromara.hutool.core.exception.HutoolException;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.reflect.ClassUtil;
import org.dromara.hutool.core.reflect.Invoker;
import org.dromara.hutool.core.reflect.ReflectUtil;

public class FieldInvoker
implements Invoker {
    private final Field field;
    private Converter converter;

    public static FieldInvoker of(Field field) {
        return new FieldInvoker(field);
    }

    public FieldInvoker(Field field) {
        this.field = Assert.notNull(field);
    }

    public Field getField() {
        return this.field;
    }

    @Override
    public String getName() {
        return this.field.getName();
    }

    @Override
    public Type getType() {
        return this.field.getGenericType();
    }

    @Override
    public Class<?> getTypeClass() {
        return this.field.getType();
    }

    public FieldInvoker setConverter(Converter converter) {
        this.converter = converter;
        return this;
    }

    @Override
    public <T> T invoke(Object target, Object ... args) {
        if (ArrayUtil.isEmpty(args)) {
            return (T)this.invokeGet(target);
        }
        if (args.length == 1) {
            this.invokeSet(target, args[0]);
            return null;
        }
        throw new HutoolException("Field [{}] cannot be set with [{}] args", this.field.getName(), args.length);
    }

    public Object invokeGet(Object obj) throws HutoolException {
        Object result;
        if (null == this.field) {
            return null;
        }
        if (obj instanceof Class) {
            obj = null;
        }
        ReflectUtil.setAccessible(this.field);
        try {
            result = this.field.get(obj);
        }
        catch (IllegalAccessException e) {
            throw new HutoolException(e, "IllegalAccess for {}.{}", this.field.getDeclaringClass(), this.field.getName());
        }
        return result;
    }

    public void invokeSet(Object obj, Object value) throws HutoolException {
        ReflectUtil.setAccessible(this.field);
        try {
            this.field.set(obj instanceof Class ? null : obj, this.convertValue(value));
        }
        catch (IllegalAccessException e) {
            throw new HutoolException(e, "IllegalAccess for [{}.{}]", null == obj ? this.field.getDeclaringClass() : obj, this.field.getName());
        }
    }

    private Object convertValue(Object value) {
        if (null == this.converter) {
            return value;
        }
        Class<?> fieldType = this.field.getType();
        if (null != value) {
            Object targetValue;
            if (!fieldType.isAssignableFrom(value.getClass()) && null != (targetValue = this.converter.convert(fieldType, value))) {
                return targetValue;
            }
        } else {
            return ClassUtil.getDefaultValue(fieldType);
        }
        return value;
    }
}

