/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.text.replacer;

import java.util.Map;
import org.dromara.hutool.core.text.finder.MultiStrFinder;
import org.dromara.hutool.core.text.replacer.StrReplacer;

public class HighMultiReplacerV2
extends StrReplacer {
    private static final long serialVersionUID = 1L;
    private final AhoCorasickAutomaton ahoCorasickAutomaton;

    public HighMultiReplacerV2(Map<String, String> map) {
        this.ahoCorasickAutomaton = new AhoCorasickAutomaton(map);
    }

    @Override
    protected int replace(CharSequence str, int pos, StringBuilder out) {
        this.ahoCorasickAutomaton.replace(str, out);
        return str.length();
    }

    @Override
    public CharSequence apply(CharSequence str) {
        StringBuilder builder = new StringBuilder();
        this.replace(str, 0, builder);
        return builder;
    }

    protected static class AhoCorasickAutomaton
    extends MultiStrFinder {
        protected final Map<String, String> replaceMap;

        public AhoCorasickAutomaton(Map<String, String> replaceMap) {
            super(replaceMap.keySet());
            this.replaceMap = replaceMap;
        }

        public void replace(CharSequence text, StringBuilder stringBuilder) {
            MultiStrFinder.Node currentNode = this.root;
            StringBuilder temp = new StringBuilder();
            for (int i = 0; i < text.length(); ++i) {
                char ch = text.charAt(i);
                Integer index = (Integer)this.charIndexMap.get(Character.valueOf(ch));
                if (index == null || index < 0) {
                    if (temp.length() > 0) {
                        stringBuilder.append((CharSequence)temp);
                        temp.delete(0, temp.length());
                    }
                    stringBuilder.append(ch);
                    currentNode = this.root;
                    continue;
                }
                currentNode = currentNode.directRouter[index];
                if (currentNode.nodeIndex == 0 && temp.length() > 0) {
                    stringBuilder.append((CharSequence)temp);
                    temp.delete(0, temp.length());
                    stringBuilder.append(ch);
                    continue;
                }
                if (currentNode.isEnd) {
                    int length = currentNode.tagetString.length() - 1;
                    temp.delete(temp.length() - length, temp.length());
                    if (temp.length() > 0) {
                        stringBuilder.append((CharSequence)temp);
                    }
                    stringBuilder.append(this.replaceMap.get(currentNode.tagetString));
                    temp.delete(0, temp.length());
                    currentNode = this.root;
                    continue;
                }
                temp.append(ch);
            }
        }
    }
}

