/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.text.replacer;

import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.text.replacer.StrReplacer;

public class RangeReplacerByStr
extends StrReplacer {
    private static final long serialVersionUID = 1L;
    private final int beginInclude;
    private final int endExclude;
    private final CharSequence replacedStr;
    private final boolean isCodePoint;

    public RangeReplacerByStr(int beginInclude, int endExclude, CharSequence replacedStr, boolean isCodePoint) {
        this.beginInclude = beginInclude;
        this.endExclude = endExclude;
        this.replacedStr = replacedStr;
        this.isCodePoint = isCodePoint;
    }

    @Override
    public String apply(CharSequence str) {
        int i;
        if (StrUtil.isEmpty(str)) {
            return StrUtil.toStringOrNull(str);
        }
        int beginInclude = this.beginInclude;
        String originalStr = str.toString();
        int[] chars = StrUtil.toChars(originalStr, this.isCodePoint);
        int strLength = chars.length;
        if (beginInclude > strLength) {
            return originalStr;
        }
        int endExclude = this.endExclude;
        if (endExclude > strLength) {
            endExclude = strLength;
        }
        if (beginInclude > endExclude) {
            return originalStr;
        }
        StringBuilder stringBuilder = new StringBuilder(originalStr.length() - (endExclude - beginInclude) + this.replacedStr.length());
        for (i = 0; i < beginInclude; ++i) {
            this.append(stringBuilder, chars[i]);
        }
        this.replace(originalStr, beginInclude, stringBuilder);
        for (i = endExclude; i < strLength; ++i) {
            this.append(stringBuilder, chars[i]);
        }
        return stringBuilder.toString();
    }

    @Override
    protected int replace(CharSequence str, int pos, StringBuilder out) {
        out.append(this.replacedStr);
        return this.endExclude;
    }

    private void append(StringBuilder stringBuilder, int c) {
        if (this.isCodePoint) {
            stringBuilder.appendCodePoint(c);
        } else {
            stringBuilder.append((char)c);
        }
    }
}

