/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.xml;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.dromara.hutool.core.exception.HutoolException;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.xml.SAXParserFactoryUtil;
import org.dromara.hutool.core.xml.XXEUtil;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XmlSaxReader {
    private final SAXParserFactory factory;
    private final InputSource source;

    public static XmlSaxReader of(InputSource source) {
        return XmlSaxReader.of(SAXParserFactoryUtil.getFactory(), source);
    }

    public static XmlSaxReader of(SAXParserFactory factory, InputSource source) {
        return new XmlSaxReader(factory, source);
    }

    public XmlSaxReader(SAXParserFactory factory, InputSource source) {
        this.factory = factory;
        this.source = source;
    }

    public void read(ContentHandler contentHandler) {
        try {
            SAXParser parse = this.factory.newSAXParser();
            if (contentHandler instanceof DefaultHandler) {
                parse.parse(this.source, (DefaultHandler)contentHandler);
                return;
            }
            XMLReader reader = XXEUtil.disableXXE(parse.getXMLReader());
            reader.setContentHandler(contentHandler);
            reader.parse(this.source);
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new HutoolException(e);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }
}

