/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db;

import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.RowId;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.collection.set.SetUtil;
import org.dromara.hutool.core.func.SerSupplier;
import org.dromara.hutool.core.map.Dict;
import org.dromara.hutool.core.reflect.method.MethodUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.CharsetUtil;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.db.DbException;
import org.dromara.hutool.db.sql.SqlUtil;

public class Entity
extends Dict {
    private static final long serialVersionUID = -1951012511464327448L;
    private String tableName;
    private Set<String> fieldNames;

    public static Entity of() {
        return new Entity();
    }

    public static Entity of(String tableName) {
        return new Entity(tableName);
    }

    public static <T> Entity parse(T bean) {
        return Entity.of(null).parseBean((Object)bean);
    }

    public static <T> Entity parse(T bean, boolean isToUnderlineCase, boolean ignoreNullValue) {
        return Entity.of(null).parseBean((Object)bean, isToUnderlineCase, ignoreNullValue);
    }

    public static <T> Entity parseWithUnderlineCase(T bean) {
        return Entity.of(null).parseBean((Object)bean, true, true);
    }

    public Entity() {
    }

    public Entity(String tableName) {
        this.tableName = tableName;
    }

    public Entity(String tableName, boolean caseInsensitive) {
        super(caseInsensitive);
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public Entity setTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public Set<String> getFieldNames() {
        return this.fieldNames;
    }

    public Entity setFieldNames(Collection<String> fieldNames) {
        if (CollUtil.isNotEmpty(fieldNames)) {
            this.fieldNames = SetUtil.of(true, fieldNames);
        }
        return this;
    }

    public Entity setFieldNames(String ... fieldNames) {
        if (ArrayUtil.isNotEmpty(fieldNames)) {
            this.fieldNames = SetUtil.ofLinked(fieldNames);
        }
        return this;
    }

    @Override
    public Entity setFields(SerSupplier<?> ... fields) {
        return (Entity)super.setFields(fields);
    }

    public Entity addFieldNames(String ... fieldNames) {
        if (ArrayUtil.isNotEmpty(fieldNames)) {
            if (null == this.fieldNames) {
                return this.setFieldNames(fieldNames);
            }
            Collections.addAll(this.fieldNames, fieldNames);
        }
        return this;
    }

    @Override
    public <T> Entity parseBean(T bean) {
        if (StrUtil.isBlank(this.tableName)) {
            this.setTableName(StrUtil.lowerFirst(bean.getClass().getSimpleName()));
        }
        return (Entity)super.parseBean(bean);
    }

    @Override
    public <T> Entity parseBean(T bean, boolean isToUnderlineCase, boolean ignoreNullValue) {
        if (StrUtil.isBlank(this.tableName)) {
            String simpleName = bean.getClass().getSimpleName();
            this.setTableName(isToUnderlineCase ? StrUtil.toUnderlineCase(simpleName) : StrUtil.lowerFirst(simpleName));
        }
        return (Entity)super.parseBean(bean, isToUnderlineCase, ignoreNullValue);
    }

    @Override
    public Entity filterNew(String ... keys) {
        Entity result = new Entity(this.tableName);
        result.setFieldNames(this.fieldNames);
        for (String key : keys) {
            if (!this.containsKey(key)) continue;
            result.put(key, this.get(key));
        }
        return result;
    }

    @Override
    public Entity removeNew(String ... keys) {
        return (Entity)super.removeNew(keys);
    }

    @Override
    public Entity set(String field, Object value) {
        return (Entity)super.set(field, value);
    }

    @Override
    public Entity setIgnoreNull(String field, Object value) {
        return (Entity)super.setIgnoreNull(field, value);
    }

    public Clob getClob(String field) {
        return (Clob)this.get(field);
    }

    public Blob getBlob(String field) {
        return (Blob)this.get(field);
    }

    @Override
    public Time getSqlTime(String field, Time defaultValue) {
        Object obj = this.get(field);
        Time result = null;
        if (null != obj) {
            try {
                result = (Time)obj;
            }
            catch (Exception e) {
                result = (Time)MethodUtil.invoke(obj, "timeValue", new Object[0]);
            }
        }
        return ObjUtil.defaultIfNull(result, defaultValue);
    }

    @Override
    public Date getDate(String field, Date defaultValue) {
        Object obj = this.get(field);
        Date result = null;
        if (null != obj) {
            try {
                result = (Date)obj;
            }
            catch (Exception e) {
                result = (Date)MethodUtil.invoke(obj, "dateValue", new Object[0]);
            }
        }
        return ObjUtil.defaultIfNull(result, defaultValue);
    }

    @Override
    public Timestamp getSqlTimestamp(String field, Timestamp defaultValue) {
        Object obj = this.get(field);
        Timestamp result = null;
        if (null != obj) {
            try {
                result = (Timestamp)obj;
            }
            catch (Exception e) {
                result = (Timestamp)MethodUtil.invoke(obj, "timestampValue", new Object[0]);
            }
        }
        return ObjUtil.defaultIfNull(result, defaultValue);
    }

    @Override
    public String getStr(String field, String defaultValue) {
        return this.getStr(field, CharsetUtil.UTF_8, defaultValue);
    }

    public String getStr(String field, Charset charset, String defaultValue) {
        Object obj = this.getObj(field, (Object)defaultValue);
        if (obj instanceof Clob) {
            return SqlUtil.clobToStr((Clob)obj);
        }
        if (obj instanceof Blob) {
            return SqlUtil.blobToStr((Blob)obj, charset);
        }
        if (obj instanceof RowId) {
            RowId rowId = (RowId)obj;
            return StrUtil.str(rowId.getBytes(), charset);
        }
        return super.getStr(field, defaultValue);
    }

    public RowId getRowId() {
        return this.getRowId("ROWID");
    }

    public RowId getRowId(String field) {
        Object obj = this.get(field);
        if (null == obj) {
            return null;
        }
        if (obj instanceof RowId) {
            return (RowId)obj;
        }
        throw new DbException("Value of field [{}] is not a rowid!", field);
    }

    @Override
    public Entity clone() {
        return (Entity)super.clone();
    }

    @Override
    public String toString() {
        return "Entity {tableName=" + this.tableName + ", fieldNames=" + this.fieldNames + ", fields=" + super.toString() + "}";
    }
}

