/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json;

import java.io.File;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.List;
import java.util.function.Predicate;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.io.file.FileUtil;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.lang.mutable.MutableEntry;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.json.JSON;
import org.dromara.hutool.json.JSONArray;
import org.dromara.hutool.json.JSONConfig;
import org.dromara.hutool.json.JSONFactory;
import org.dromara.hutool.json.JSONObject;
import org.dromara.hutool.json.JSONPrimitive;
import org.dromara.hutool.json.serializer.TypeAdapter;
import org.dromara.hutool.json.serializer.TypeAdapterManager;
import org.dromara.hutool.json.support.JSONStrFormatter;
import org.dromara.hutool.json.xml.JSONXMLUtil;

public class JSONUtil {
    public static JSONObject ofObj() {
        return JSONFactory.getInstance().ofObj();
    }

    public static JSONObject ofObj(JSONConfig config) {
        return JSONFactory.of(config, null).ofObj();
    }

    public static JSONArray ofArray() {
        return JSONFactory.getInstance().ofArray();
    }

    public static JSONArray ofArray(JSONConfig config) {
        return JSONFactory.of(config, null).ofArray();
    }

    public static JSONPrimitive ofPrimitive(Object value) {
        return JSONFactory.getInstance().ofPrimitive(value);
    }

    public static JSONPrimitive ofPrimitive(Object value, JSONConfig config) {
        return JSONFactory.of(config, null).ofPrimitive(value);
    }

    public static JSONObject parseObj(Object obj) {
        return JSONFactory.getInstance().parseObj(obj);
    }

    public static JSONObject parseObj(Object obj, JSONConfig config) {
        return JSONUtil.parseObj(obj, config, null);
    }

    public static JSONObject parseObj(Object obj, JSONConfig config, Predicate<MutableEntry<Object, Object>> predicate) {
        return JSONFactory.of(config, predicate).parseObj(obj);
    }

    public static JSONArray parseArray(Object obj) {
        return JSONFactory.getInstance().parseArray(obj);
    }

    public static JSONArray parseArray(Object obj, JSONConfig config) {
        return JSONUtil.parseArray(obj, config, null);
    }

    public static JSONArray parseArray(Object obj, JSONConfig config, Predicate<MutableEntry<Object, Object>> predicate) {
        return JSONFactory.of(config, predicate).parseArray(obj);
    }

    public static JSON parse(Object obj) {
        return JSONFactory.getInstance().parse(obj);
    }

    public static JSON parse(Object obj, JSONConfig config) {
        return JSONUtil.parse(obj, config, null);
    }

    public static JSON parse(Object obj, JSONConfig config, Predicate<MutableEntry<Object, Object>> predicate) {
        return JSONFactory.of(config, predicate).parse(obj);
    }

    public static JSONObject parseFromXml(String xmlStr) {
        return JSONXMLUtil.toJSONObject(xmlStr);
    }

    public static JSON readJSON(File file, Charset charset) throws IORuntimeException {
        return FileUtil.read(file, charset, JSONUtil::parse);
    }

    public static JSONObject readJSONObject(File file, Charset charset) throws IORuntimeException {
        return FileUtil.read(file, charset, JSONUtil::parseObj);
    }

    public static JSONArray readJSONArray(File file, Charset charset) throws IORuntimeException {
        return FileUtil.read(file, charset, JSONUtil::parseArray);
    }

    public static String toJsonPrettyStr(Object obj) {
        return JSONUtil.parse(obj).toStringPretty();
    }

    public static String toJsonStr(Object obj) {
        return JSONUtil.parse(obj).toString();
    }

    public static String toJsonStr(Object obj, JSONConfig jsonConfig) {
        if (null == obj) {
            return null;
        }
        return JSONUtil.parse(obj, jsonConfig).toString();
    }

    public static void toJsonStr(Object obj, Appendable appendable) {
        Assert.notNull(appendable);
        JSONFactory jsonFactory = JSONFactory.getInstance();
        JSON json = jsonFactory.parse(obj);
        json.write(jsonFactory.ofWriter(appendable, 0));
    }

    public static String toXmlStr(JSON json) {
        return JSONXMLUtil.toXml(json);
    }

    public static JSONObject xmlToJson(String xml) {
        return JSONXMLUtil.toJSONObject(xml);
    }

    public static <T> T toBean(Object json, Class<T> clazz) {
        Assert.notNull(clazz);
        return JSONUtil.toBean(json, clazz);
    }

    public static <T> T toBean(Object obj, Type type) {
        if (null == obj) {
            return null;
        }
        return JSONUtil.parse(obj).toBean(type);
    }

    public static <T> T toBean(Object obj, JSONConfig config, Type type) {
        if (null == obj) {
            return null;
        }
        return JSONUtil.parse(obj, config).toBean(type);
    }

    public static JSON toJSON(Object obj) {
        return JSONFactory.getInstance().toJSON(obj);
    }

    public static JSON toJSON(Object obj, JSONConfig config) {
        return JSONUtil.toJSON(obj, config, null);
    }

    public static JSON toJSON(Object obj, JSONConfig config, Predicate<MutableEntry<Object, Object>> predicate) {
        return JSONFactory.of(config, predicate).toJSON(obj);
    }

    public static <T> List<T> toList(String jsonArray, Class<T> elementType) {
        return JSONUtil.toList(JSONUtil.parseArray(jsonArray), elementType);
    }

    public static <T> List<T> toList(JSONArray jsonArray, Class<T> elementType) {
        return null == jsonArray ? null : jsonArray.toList(elementType);
    }

    public static <T> T getObjByPath(JSON json, String expression) {
        return (T)JSONUtil.getByPath(json, expression, Object.class);
    }

    public static <T> T getByPath(JSON json, String expression, Type type) {
        if (null == json || StrUtil.isBlank(expression)) {
            return null;
        }
        return json.getByPath(expression, type);
    }

    public static <T> T getByPath(JSON json, String expression, T defaultValue) {
        if (null == json || StrUtil.isBlank(expression)) {
            return defaultValue;
        }
        if (null != defaultValue) {
            Class<?> type = defaultValue.getClass();
            return ObjUtil.defaultIfNull(json.getByPath(expression, type), defaultValue);
        }
        return (T)json.getByPath(expression);
    }

    public static JSON getByPath(JSON json, String expression) {
        if (null == json || StrUtil.isBlank(expression)) {
            return null;
        }
        return json.getByPath(expression);
    }

    public static String formatJsonStr(String jsonStr) {
        return JSONStrFormatter.INSTANCE.format(jsonStr);
    }

    public static boolean isEmpty(JSON json) {
        if (null == json) {
            return true;
        }
        return json.isEmpty();
    }

    public static boolean isTypeJSON(String str) {
        return JSONUtil.isTypeJSONObject(str) || JSONUtil.isTypeJSONArray(str);
    }

    public static boolean isTypeJSONObject(String str) {
        if (StrUtil.isBlank(str)) {
            return false;
        }
        return StrUtil.isWrap((CharSequence)StrUtil.trim(str), '{', '}');
    }

    public static boolean isTypeJSONArray(String str) {
        if (StrUtil.isBlank(str)) {
            return false;
        }
        return StrUtil.isWrap((CharSequence)StrUtil.trim(str), '[', ']');
    }

    public void registerTypeAdapter(Type type, TypeAdapter typeAdapter) {
        TypeAdapterManager.getInstance().register(type, typeAdapter);
    }

    public void registerTypeAdapter(TypeAdapter typeAdapter) {
        TypeAdapterManager.getInstance().register(typeAdapter);
    }
}

