/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json.serializer.impl;

import java.io.InputStream;
import java.io.Reader;
import org.dromara.hutool.json.JSON;
import org.dromara.hutool.json.JSONFactory;
import org.dromara.hutool.json.reader.JSONParser;
import org.dromara.hutool.json.reader.JSONTokener;
import org.dromara.hutool.json.serializer.JSONContext;
import org.dromara.hutool.json.serializer.MatcherJSONSerializer;

public class TokenerSerializer
implements MatcherJSONSerializer<Object> {
    public static final TokenerSerializer INSTANCE = new TokenerSerializer();

    @Override
    public boolean match(Object bean, JSONContext context) {
        return bean instanceof Reader || bean instanceof InputStream;
    }

    @Override
    public JSON serialize(Object bean, JSONContext context) {
        if (bean instanceof JSONTokener) {
            return this.mapFromTokener((JSONTokener)bean, context.getFactory());
        }
        if (bean instanceof JSONParser) {
            return ((JSONParser)bean).parse();
        }
        if (bean instanceof Reader) {
            return this.mapFromTokener(new JSONTokener((Reader)bean), context.getFactory());
        }
        if (bean instanceof InputStream) {
            return this.mapFromTokener(new JSONTokener((InputStream)bean), context.getFactory());
        }
        throw new IllegalArgumentException("Unsupported source: " + bean);
    }

    private JSON mapFromTokener(JSONTokener tokener, JSONFactory factory) {
        return factory.ofParser(tokener).parse();
    }
}

