/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.setting.props;

import java.util.Map;
import org.dromara.hutool.core.io.file.FileNameUtil;
import org.dromara.hutool.core.io.resource.NoResourceException;
import org.dromara.hutool.core.map.concurrent.SafeConcurrentHashMap;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.setting.props.Props;

public class PropsUtil {
    private static final Map<String, Props> propsMap = new SafeConcurrentHashMap<String, Props>();

    public static Props get(String name) {
        return propsMap.computeIfAbsent(name, filePath -> {
            String extName = FileNameUtil.extName(filePath);
            if (StrUtil.isEmpty(extName)) {
                filePath = filePath + "." + "properties";
            }
            return new Props((String)filePath);
        });
    }

    public static Props getFirstFound(String ... names) {
        for (String name : names) {
            try {
                return PropsUtil.get(name);
            }
            catch (NoResourceException noResourceException) {
            }
        }
        return null;
    }

    public static Props getSystemProps() {
        return new Props(System.getProperties());
    }
}

