/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.setting.yaml;

import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.io.resource.ResourceUtil;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.map.Dict;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class YamlUtil {
    public static Dict loadByPath(String path) {
        return YamlUtil.loadByPath(path, Dict.class);
    }

    public static <T> T loadByPath(String path, Class<T> type) {
        return YamlUtil.load(ResourceUtil.getStream(path), type);
    }

    public static <T> T load(InputStream in, Class<T> type) {
        return YamlUtil.load(IoUtil.toBomReader(in), type);
    }

    public static Dict load(Reader reader) {
        return YamlUtil.load(reader, Dict.class);
    }

    public static <T> T load(Reader reader, Class<T> type) {
        return YamlUtil.load(reader, type, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T load(Reader reader, Class<T> type, boolean isCloseReader) {
        Object object;
        block4: {
            Assert.notNull(reader, "Reader must be not null !", new Object[0]);
            if (null == type) {
                type = Object.class;
            }
            Yaml yaml = new Yaml();
            try {
                object = yaml.loadAs(reader, type);
                if (!isCloseReader) break block4;
            }
            catch (Throwable throwable) {
                if (isCloseReader) {
                    IoUtil.closeQuietly(reader);
                }
                throw throwable;
            }
            IoUtil.closeQuietly(reader);
        }
        return (T)object;
    }

    public static void dump(Object object, Writer writer) {
        DumperOptions options = new DumperOptions();
        options.setIndent(2);
        options.setPrettyFlow(true);
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        YamlUtil.dump(object, writer, options);
    }

    public static void dump(Object object, Writer writer, DumperOptions dumperOptions) {
        if (null == dumperOptions) {
            dumperOptions = new DumperOptions();
        }
        Yaml yaml = new Yaml(dumperOptions);
        yaml.dump(object, writer);
    }
}

