/*
 * Copyright (c) 2013-2024 Hutool Team and hutool.cn
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * POI封装实现<br>
 * Java针对MS Office的操作的库屈指可数，比较有名的就是Apache的POI库。<br>
 * 这个库异常强大，但是使用起来也并不容易。Hutool针对POI封装一些常用工具，使Java操作Excel等文件变得异常简单。
 *
 * <ul>
 *     <li>HSSF － 提供读写Microsoft Excel XLS 格式文件的功能</li>
 *     <li>XSSF － 提供读写Microsoft Excel OOXML XLSX 格式文件的功能</li>
 *     <li>HWPF － 提供读写Microsoft Word DOC 格式文件的功能</li>
 *     <li>XWPF － 提供读写Microsoft Word DOCX 格式文件的功能</li>
 *     <li>HSLF － 提供读写Microsoft PowerPoint格式文件的功能</li>
 *     <li>HDGF － 提供读Microsoft Visio格式文件的功能</li>
 *     <li>HPBF － 提供读Microsoft Publisher格式文件的功能</li>
 *     <li>HSMF － 提供读Microsoft Outlook格式文件的功能</li>
 * </ul>
 *
 * @author looly
 *
 */
package org.dromara.hutool.poi;
