/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.annotation.elements;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.dromara.hutool.core.annotation.AnnotationUtil;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.collection.set.SetUtil;
import org.dromara.hutool.core.map.TableMap;

public class CombinationAnnotatedElement
implements AnnotatedElement,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Set<Class<? extends Annotation>> META_ANNOTATIONS = SetUtil.of(Target.class, Retention.class, Inherited.class, Documented.class, SuppressWarnings.class, Override.class, Deprecated.class);
    private Map<Class<? extends Annotation>, Annotation> annotationMap;
    private Map<Class<? extends Annotation>, Annotation> declaredAnnotationMap;
    private final Predicate<Annotation> predicate;

    public static CombinationAnnotatedElement of(AnnotatedElement element, Predicate<Annotation> predicate) {
        return new CombinationAnnotatedElement(element, predicate);
    }

    public CombinationAnnotatedElement(AnnotatedElement element) {
        this(element, null);
    }

    public CombinationAnnotatedElement(AnnotatedElement element, Predicate<Annotation> predicate) {
        this.predicate = predicate;
        this.init(element);
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.annotationMap.containsKey(annotationClass);
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        Annotation annotation = this.annotationMap.get(annotationClass);
        return (T)(annotation == null ? null : annotation);
    }

    @Override
    public Annotation[] getAnnotations() {
        Collection<Annotation> annotations = this.annotationMap.values();
        return annotations.toArray(new Annotation[0]);
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        Collection<Annotation> annotations = this.declaredAnnotationMap.values();
        return annotations.toArray(new Annotation[0]);
    }

    private void init(AnnotatedElement element) {
        Annotation[] declaredAnnotations = AnnotationUtil.getDeclaredAnnotations(element);
        this.declaredAnnotationMap = new TableMap<Class<? extends Annotation>, Annotation>();
        this.parseDeclared(declaredAnnotations);
        Annotation[] annotations = element.getAnnotations();
        if (declaredAnnotations.length == annotations.length) {
            this.annotationMap = this.declaredAnnotationMap;
        } else {
            this.annotationMap = new TableMap<Class<? extends Annotation>, Annotation>();
            this.parse(annotations);
        }
    }

    private void parseDeclared(Annotation[] annotations) {
        if (ArrayUtil.isEmpty(annotations)) {
            return;
        }
        for (Annotation annotation : annotations) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (META_ANNOTATIONS.contains(annotationType) || this.declaredAnnotationMap.containsKey(annotationType)) continue;
            if (this.test(annotation)) {
                this.declaredAnnotationMap.put(annotationType, annotation);
            }
            this.parseDeclared(AnnotationUtil.getDeclaredAnnotations(annotationType));
        }
    }

    private void parse(Annotation[] annotations) {
        if (ArrayUtil.isEmpty(annotations)) {
            return;
        }
        for (Annotation annotation : annotations) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (META_ANNOTATIONS.contains(annotationType) || this.annotationMap.containsKey(annotationType)) continue;
            if (this.test(annotation)) {
                this.annotationMap.put(annotationType, annotation);
            }
            this.parse(annotationType.getAnnotations());
        }
    }

    private boolean test(Annotation annotation) {
        return null == this.predicate || this.predicate.test(annotation);
    }
}

