/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.dromara.hutool.core.collection.BoundedCollection;
import org.dromara.hutool.core.collection.ListWrapper;

public class BoundedList<E>
extends ListWrapper<E>
implements BoundedCollection<E> {
    private final int maxSize;

    public BoundedList(int maxSize) {
        this(new ArrayList(maxSize), maxSize);
    }

    public BoundedList(List<E> raw, int maxSize) {
        super(raw);
        this.maxSize = maxSize;
    }

    @Override
    public boolean isFull() {
        return this.size() == this.maxSize;
    }

    @Override
    public int maxSize() {
        return this.maxSize;
    }

    @Override
    public boolean add(E e) {
        this.checkFull(1);
        return super.add(e);
    }

    @Override
    public void add(int index, E element) {
        this.checkFull(1);
        super.add(index, element);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        this.checkFull(c.size());
        return super.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        this.checkFull(c.size());
        return super.addAll(index, c);
    }

    private void checkFull(int addSize) {
        if (this.size() + addSize > this.maxSize) {
            throw new IndexOutOfBoundsException("List is no space to add " + addSize + " elements!");
        }
    }
}

